/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.metadata.DeclarationBasedMetadataCacheIdGenerator;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.AstConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.ComponentParameterizationBasedMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.DslElementBasedMetadataCacheIdGenerator;

public abstract class AbstractMetadataCacheIdGeneratorTestCase
extends AbstractDslModelTestCase {
    protected Set<ExtensionModel> extensions;
    protected DslResolvingContext dslResolvingContext;
    protected ElementDeclarer declarer;
    protected DslElementModelFactory dslFactory;

    @Before
    public void setUp() throws Exception {
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        this.dslResolvingContext = DslResolvingContext.getDefault(this.extensions);
        this.declarer = ElementDeclarer.forExtension((String)"extension");
        this.dslFactory = DslElementModelFactory.getDefault((DslResolvingContext)this.dslResolvingContext);
    }

    protected MetadataCacheId getIdForComponentOutputMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentOutputMetadata((Object)component).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForComponentOutputMetadata((Object)component).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForComponentOutputMetadata(this.dslFactory.create(component).get()).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForComponentOutputMetadata((Object)elementDeclaration).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentOutputMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return modelBasedId;
    }

    protected MetadataCacheId getIdForComponentAttributesMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentAttributesMetadata((Object)component).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForComponentAttributesMetadata((Object)component).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForComponentAttributesMetadata(this.dslFactory.create(component).get()).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForComponentAttributesMetadata((Object)elementDeclaration).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentAttributesMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return modelBasedId;
    }

    protected MetadataCacheId getIdForComponentInputMetadata(ArtifactDeclaration declaration, String location, String parameterName) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentInputMetadata((Object)component, parameterName).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForComponentInputMetadata((Object)component, parameterName).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForComponentInputMetadata(this.dslFactory.create(component).get(), parameterName).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForComponentInputMetadata((Object)elementDeclaration, parameterName).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentInputMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component), parameterName).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return modelBasedId;
    }

    protected MetadataCacheId getIdForComponentMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForComponentMetadata((Object)component).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForComponentMetadata((Object)component).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForComponentMetadata(this.dslFactory.create(component).get()).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForComponentMetadata((Object)elementDeclaration).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForComponentMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return dslBasedId;
    }

    protected MetadataCacheId getIdForMetadataKeys(ArtifactDeclaration declaration, String location) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForMetadataKeys((Object)component).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForMetadataKeys((Object)component).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForMetadataKeys(this.dslFactory.create(component).get()).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForMetadataKeys((Object)elementDeclaration).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForMetadataKeys((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return modelBasedId;
    }

    protected MetadataCacheId getIdForGlobalMetadata(ArtifactDeclaration declaration, String location) throws Exception {
        ArtifactAst app = this.loadApplicationModel(declaration);
        ComponentAst component = new Locator(app).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).get();
        ElementDeclaration elementDeclaration = (ElementDeclaration)declaration.findElement(Location.builderFromStringRepresentation((String)location).build()).get();
        MetadataCacheId astBasedId = (MetadataCacheId)this.createAstBasedGenerator(app).getIdForGlobalMetadata((Object)component).get();
        MetadataCacheId modelBasedId = (MetadataCacheId)this.createModelBasedGenerator(app).getIdForGlobalMetadata((Object)component).get();
        MetadataCacheId dslBasedId = (MetadataCacheId)this.createDslBasedGenerator(app, this.dslFactory).getIdForGlobalMetadata(this.dslFactory.create(component).get()).get();
        MetadataCacheId declarationBasedId = (MetadataCacheId)this.createDeclarationBasedGenerator(declaration).getIdForGlobalMetadata((Object)elementDeclaration).get();
        MetadataCacheId parameterizationBasedId = (MetadataCacheId)this.createComponentParameterizationBasedGenerator(app).getIdForGlobalMetadata((Object)MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)component)).get();
        MatcherAssert.assertThat((Object)parameterizationBasedId, (Matcher)Matchers.equalTo((Object)modelBasedId));
        MatcherAssert.assertThat((Object)modelBasedId, (Matcher)Matchers.equalTo((Object)dslBasedId));
        MatcherAssert.assertThat((Object)dslBasedId, (Matcher)Matchers.equalTo((Object)declarationBasedId));
        MatcherAssert.assertThat((Object)declarationBasedId, (Matcher)Matchers.equalTo((Object)astBasedId));
        return modelBasedId;
    }

    private MetadataCacheIdGenerator<ComponentAst> createAstBasedGenerator(ArtifactAst app) {
        return new ComponentAstBasedMetadataCacheIdGenerator((ComponentLocator)new Locator(app));
    }

    private MetadataCacheIdGenerator<ComponentAst> createModelBasedGenerator(ArtifactAst app) {
        return new ModelBasedMetadataCacheIdGeneratorFactory().create(this.dslResolvingContext, (ComponentLocator)new Locator(app));
    }

    private MetadataCacheIdGenerator<DslElementModel<?>> createDslBasedGenerator(ArtifactAst app, DslElementModelFactory factory) {
        Locator astLocator = new Locator(app);
        ComponentLocator dslLocator = l -> astLocator.get(l).map(e -> factory.create(e).orElse(null));
        return new DslElementBasedMetadataCacheIdGenerator(dslLocator);
    }

    private MetadataCacheIdGenerator<ComponentParameterization<?>> createComponentParameterizationBasedGenerator(ArtifactAst app) {
        AstConfigurationMetadataCacheIdGenerator configGenerator = new AstConfigurationMetadataCacheIdGenerator();
        configGenerator.addConfigurations(app.topLevelComponentsStream().filter(potentialConfig -> potentialConfig.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList()));
        return new ComponentParameterizationBasedMetadataCacheIdGenerator((ConfigurationMetadataCacheIdGenerator)configGenerator);
    }

    private MetadataCacheIdGenerator<ElementDeclaration> createDeclarationBasedGenerator(ArtifactDeclaration app) {
        ComponentLocator declarationLocator = l -> app.findElement(Location.builderFromStringRepresentation((String)l.toString()).build());
        return new DeclarationBasedMetadataCacheIdGenerator(this.dslResolvingContext, declarationLocator);
    }

    protected ArtifactAst loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return ArtifactDeclarationUtils.toArtifactast((ArtifactDeclaration)declaration, this.extensions);
    }

    protected static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<org.mule.runtime.api.component.location.Location, ComponentAst> components = new HashMap<org.mule.runtime.api.component.location.Location, ComponentAst>();

        Locator(ArtifactAst app) {
            app.topLevelComponentsStream().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(org.mule.runtime.api.component.location.Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private org.mule.runtime.api.component.location.Location getLocation(ComponentAst component) {
            return org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)component.getLocation().getLocation()).build();
        }

        private void addComponent(ComponentAst component) {
            this.components.put(this.getLocation(component), component);
            component.directChildrenStream().forEach(this::addComponent);
        }
    }
}

