/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.metadata.ComponentBasedValueProviderCacheIdGenerator;
import org.mule.runtime.config.api.dsl.model.metadata.DeclarationBasedValueProviderCacheIdGenerator;
import org.mule.runtime.config.dsl.model.AbstractMockedValueProviderExtensionTestCase;
import org.mule.runtime.config.dsl.model.ComplexActingParameter;
import org.mule.runtime.config.dsl.model.ComplexActingParameterUtils;
import org.mule.runtime.config.dsl.model.DeclarationUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedValueProviderCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.DslElementBasedValueProviderCacheIdGenerator;

public class ValueProviderCacheIdGeneratorTestCase
extends AbstractMockedValueProviderExtensionTestCase {
    private DslElementModelFactory dslElementModelFactory;

    @Override
    public void before() {
        super.before();
        this.dslElementModelFactory = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
    }

    private Optional<ValueProviderCacheId> computeIdFor(ArtifactDeclaration appDeclaration, String location, String parameterName) throws Exception {
        return this.computeIdFor(appDeclaration, location, parameterName, null);
    }

    private Optional<ValueProviderCacheId> computeIdFor(ArtifactDeclaration appDeclaration, String location, String parameterName, String targetSelector) throws Exception {
        Optional astId;
        Optional declarationBasedId;
        Optional componentBasedId;
        Optional dslElementId;
        ArtifactAst app = this.loadApplicationModel(appDeclaration);
        AbstractMockedValueProviderExtensionTestCase.Locator locator = new AbstractMockedValueProviderExtensionTestCase.Locator(app);
        ComponentLocator dslLocator = l -> this.getDeclaration(appDeclaration, l.toString()).map(d -> this.dslElementModelFactory.create(d).orElse(null));
        ComponentLocator declarationLocator = l -> appDeclaration.findElement(Location.builderFromStringRepresentation((String)l.toString()).build());
        ComponentAstBasedValueProviderCacheIdGenerator componentAstBasedValueProviderCacheIdGenerator = new ComponentAstBasedValueProviderCacheIdGenerator((ComponentLocator)locator);
        ComponentBasedValueProviderCacheIdGenerator componentBasedValueProviderCacheIdGenerator = new ComponentBasedValueProviderCacheIdGenerator(this.dslContext, (ComponentLocator)locator);
        DslElementBasedValueProviderCacheIdGenerator dslElementModelValueProviderCacheIdGenerator = new DslElementBasedValueProviderCacheIdGenerator(dslLocator);
        DeclarationBasedValueProviderCacheIdGenerator elementDeclarationValueProviderCacheIdGenerator = new DeclarationBasedValueProviderCacheIdGenerator(this.dslContext, declarationLocator);
        ComponentAst component = this.getComponentAst(app, location);
        DslElementModel dslElementModel = (DslElementModel)dslLocator.get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location).build()).orElseThrow(() -> new AssertionError((Object)"Could not create dslElementModel"));
        Optional elementDeclaration = appDeclaration.findElement(Location.builderFromStringRepresentation((String)location).build());
        Optional elementModel = component.getModel(ParameterizedModel.class);
        if (!elementDeclaration.isPresent() || !elementModel.isPresent()) {
            TestCase.fail((String)String.format("missing declaration or model for: %s", location));
        }
        if (targetSelector == null) {
            dslElementId = dslElementModelValueProviderCacheIdGenerator.getIdForResolvedValues((Object)dslElementModel, parameterName);
            componentBasedId = componentBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName);
            declarationBasedId = elementDeclarationValueProviderCacheIdGenerator.getIdForResolvedValues(elementDeclaration.get(), parameterName);
            astId = componentAstBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName);
        } else {
            dslElementId = dslElementModelValueProviderCacheIdGenerator.getIdForResolvedValues((Object)dslElementModel, parameterName, targetSelector);
            componentBasedId = componentBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName, targetSelector);
            declarationBasedId = elementDeclarationValueProviderCacheIdGenerator.getIdForResolvedValues(elementDeclaration.get(), parameterName, targetSelector);
            astId = componentAstBasedValueProviderCacheIdGenerator.getIdForResolvedValues((Object)component, parameterName, targetSelector);
        }
        this.checkIdsAreEqual(astId, dslElementId);
        this.checkIdsAreEqual(dslElementId, componentBasedId);
        this.checkIdsAreEqual(componentBasedId, declarationBasedId);
        return dslElementId;
    }

    @Test
    public void idForParameterWithNoProviderInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myConfig", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInSource() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/source", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInOperation() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForConfigNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingNotActingParameters() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationDefaultValueHashIdShouldBeSameWithExplicitValueOnActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.removeParameter(app, "myFlow/processors/0", "actingParameter");
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        DeclarationUtils.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/source", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/source", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        DeclarationUtils.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void equalConfigsWithDifferentNameGetSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithSameParameterGetSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareOtherConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentValueProviderNameGetsSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderName()).thenReturn((Object)"newValueProviderName");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    @Test
    public void differentValueProviderIdGetsDifferentHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithSameParametersGetsSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    @Test
    public void differentHashForComplexActingParameterValue() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        LinkedList allIds = new LinkedList();
        ComplexActingParameterUtils.forAllComplexActingParameterChanges(app, "myFlow/processors/0", "complexActingParameter", (CheckedConsumer<ComplexActingParameter>)((CheckedConsumer)v -> allIds.add(this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter"))));
        for (Optional idA : allIds) {
            for (Optional idB : allIds) {
                if (idA == idB) continue;
                this.checkIdsAreDifferent(idA, idB);
            }
        }
    }

    @Test
    public void extractionExpressionIsUsedForActingParameters() throws Exception {
        String extractionExpression = "actingParameter";
        String otherParameterName = "otherParameterName";
        ActingParameterModel actingParameterModel = this.createActingParameterModel("otherParameterName");
        Mockito.when((Object)actingParameterModel.getExtractionExpression()).thenReturn((Object)"actingParameter");
        Mockito.when((Object)this.valueProviderModel.getActingParameters()).thenReturn(Collections.singletonList("otherParameterName"));
        Mockito.when((Object)this.valueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> operationId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)operationId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(operationId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void wholeParameterIsUsedIfExpressionPointsToField() throws Exception {
        String extractionExpression = "complexActingParameter.stringParam";
        ActingParameterModel actingParameterModel = this.createActingParameterModel("actingParameter");
        Mockito.when((Object)actingParameterModel.getExtractionExpression()).thenReturn((Object)"complexActingParameter.stringParam");
        Mockito.when((Object)this.valueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> operationId = this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter");
        MatcherAssert.assertThat((Object)operationId.isPresent(), (Matcher)Matchers.is((Object)true));
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "complexActingParameter", p -> {
            HashMap<String, ParameterValue> complexDeclaration = new HashMap<String, ParameterValue>(((ParameterObjectValue)p.getValue()).getParameters());
            complexDeclaration.put("intParam", ParameterSimpleValue.plain((String)"999"));
            ((ParameterObjectValue)p.getValue()).setParameters(complexDeclaration);
        });
        this.checkIdsAreDifferent(operationId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void presentFieldValueProviderGetsId() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        Mockito.when((Object)this.providedParameter.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> cacheId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "some.target.path");
        MatcherAssert.assertThat((Object)cacheId.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        cacheId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "other.field");
        MatcherAssert.assertThat((Object)cacheId.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void changesInParameterWithActingFieldReturnsDifferentHash() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("complexActingParameter", "complexActingParameter.innerPojoParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameterFromComplex.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactDeclaration app = this.getBaseApp();
        LinkedList allIds = new LinkedList();
        ComplexActingParameterUtils.forAllComplexActingParameterChanges(app, "myFlow/processors/0", "complexActingParameter", (CheckedConsumer<ComplexActingParameter>)((CheckedConsumer)v -> allIds.add(this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter", "some.target.path"))));
        for (Optional idA : allIds) {
            for (Optional idB : allIds) {
                if (idA == idB) continue;
                this.checkIdsAreDifferent(idA, idB);
            }
        }
    }

    @Test
    public void actingFieldFromNotExistentParameterIsNotConsideredForId() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("actingParameter", "notExistentParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameter.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> id = this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "some.target.path");
        MatcherAssert.assertThat((Object)id.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void actingFieldAsExpressionUsesWholeParameter() throws Exception {
        String targetSelector = "some.target.path";
        FieldValueProviderModel fieldValueProviderModel = this.createFieldValueProviderModel("fieldValueProvider", "fieldValueProviderId", "some.target.path");
        ActingParameterModel actingParameterModel = this.createActingParameterModel("complexActingParameter", "complexActingParameter.innerPojoParam.stringParam");
        Mockito.when((Object)fieldValueProviderModel.getParameters()).thenReturn(Collections.singletonList(actingParameterModel));
        Mockito.when((Object)this.providedParameterFromComplex.getFieldValueProviderModels()).thenReturn(Collections.singletonList(fieldValueProviderModel));
        ArtifactDeclaration app = this.getBaseApp();
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "complexActingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"#['complexActingParameter']")));
        Optional<ValueProviderCacheId> originalExpressionId = this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter", "some.target.path");
        DeclarationUtils.modifyParameter(app, "myFlow/processors/0", "complexActingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"#['otherComplexActingParameter']")));
        Optional<ValueProviderCacheId> otherExpressionId = this.computeIdFor(app, "myFlow/processors/0", "fromComplexActingParameter", "some.target.path");
        this.checkIdsAreDifferent(originalExpressionId, otherExpressionId);
    }

    @Test
    public void invalidTargetSelector() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "providedParameter", "this-is-not&a$$$val*d@path").isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

