/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.spring;

import io.qameta.allure.Issue;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;

@Issue(value="W-10672687")
public class ObjectFactoryClassRepositoryTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();

    @Test
    public void testSetters() throws Exception {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        byteBuddyClass.setIsSingleton(Boolean.valueOf(true));
        byteBuddyClass.setIsPrototype(Boolean.valueOf(true));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> true));
        Assert.assertThat((Object)byteBuddyClass.isSingleton(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)byteBuddyClass.isPrototype(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)byteBuddyClass.isEagerInit(), (Matcher)Is.is((Object)true));
        byteBuddyClass.setIsSingleton(Boolean.valueOf(false));
        byteBuddyClass.setIsPrototype(Boolean.valueOf(false));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> false));
        Assert.assertThat((Object)byteBuddyClass.isSingleton(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)byteBuddyClass.isPrototype(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)byteBuddyClass.isEagerInit(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)byteBuddyClass.getObject(), (Matcher)Is.is((Matcher)Matchers.instanceOf(FakeObject.class)));
    }

    @Test
    @Issue(value="W-12362157")
    public void getObjectTypeWithoutInitializingTheFields() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(String.class));
    }

    @Test
    @Issue(value="W-12362157")
    public void testSameClassWithDifferentObjectTypeCreateDifferentDynamicClasses() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor otherByteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, Integer.class).newInstance();
        Assert.assertThat(byteBuddyClass.getClass(), (Matcher)Is.is((Matcher)IsNot.not(otherByteBuddyClass.getClass())));
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)otherByteBuddyClass.getObjectType(), (Matcher)Is.is(Integer.class));
        Assert.assertThat((Object)byteBuddyClass.getClass().getSuperclass().getName(), (Matcher)Is.is((Object)otherByteBuddyClass.getClass().getSuperclass().getName()));
    }

    @Test
    public void testGetObjectTypeReturnsSuperIfImplementsObjectTypeProvider() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        ObjectFactoryClassRepository.SmartFactoryBeanInterceptor byteBuddyClass = (ObjectFactoryClassRepository.SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(OtherFakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        Assert.assertThat((Object)byteBuddyClass.getObjectType(), (Matcher)Is.is(Long.class));
    }

    public static class FakeObject
    extends AbstractComponent {
    }

    public static class OtherFakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory
    implements ObjectTypeProvider {
        public Object doGetObject() {
            return new FakeObject();
        }

        public Class<?> getObjectType() {
            return Long.class;
        }
    }

    public static class FakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() {
            return new FakeObject();
        }
    }
}

