/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.internal.bean.NotificationConfig;
import org.mule.runtime.config.internal.bean.ServerNotificationManagerConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.NotificationsProvider;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.context.ApplicationContext;

public class ServerNotificationManagerConfiguratorTestCase
extends AbstractMuleTestCase {
    private Registry registry;
    private ServerNotificationManager notificationManager;
    private MuleContext context;
    private ServerNotificationManagerConfigurator configurator;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void before() {
        this.registry = (Registry)Mockito.mock(Registry.class);
        this.notificationManager = (ServerNotificationManager)Mockito.mock(ServerNotificationManager.class);
        this.context = (MuleContext)Mockito.mock(MuleContext.class);
        ((MuleContext)Mockito.doReturn((Object)this.notificationManager).when((Object)this.context)).getNotificationManager();
        this.configurator = new ServerNotificationManagerConfigurator();
        this.configurator.setMuleContext(this.context);
        this.configurator.setRegistry(this.registry);
        ApplicationContext springContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        ((ApplicationContext)Mockito.doReturn((Object)new String[0]).when((Object)springContext)).getBeanNamesForType(NotificationListener.class, false, true);
        this.configurator.setApplicationContext(springContext);
    }

    @Test
    public void compliantEnabledNotification() throws InitialisationException {
        ((Registry)Mockito.doReturn(Collections.singletonList(() -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        this.configurator.setEnabledNotifications(Collections.singletonList(new NotificationConfig.EnabledNotificationConfig(CompliantNotificationListener.class, CompliantNotification.class)));
        this.configurator.initialise();
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).addInterfaceToType(CompliantNotificationListener.class, CompliantNotification.class);
    }

    @Test
    public void compliantEnabledDuplicateNotification() throws InitialisationException {
        ((Registry)Mockito.doReturn(Arrays.asList(() -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)), () -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        this.configurator.setEnabledNotifications(Collections.singletonList(new NotificationConfig.EnabledNotificationConfig(CompliantNotificationListener.class, CompliantNotification.class)));
        this.expected.expect(InitialisationException.class);
        this.expected.expectMessage(Matchers.containsString((String)"'test:COMPLIANT'"));
        this.configurator.initialise();
    }

    @Test
    public void compliantDisabledNotificationByEventClass() throws InitialisationException {
        ((Registry)Mockito.doReturn(Collections.singletonList(() -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        NotificationConfig.DisabledNotificationConfig disableNotificationConfig = new NotificationConfig.DisabledNotificationConfig();
        disableNotificationConfig.setEventClass(CompliantNotification.class);
        this.configurator.setDisabledNotifications(Collections.singletonList(disableNotificationConfig));
        this.configurator.initialise();
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).disableType(CompliantNotification.class);
    }

    @Test
    public void compliantDisabledNotificationByEventName() throws InitialisationException {
        ((Registry)Mockito.doReturn(Collections.singletonList(() -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        NotificationConfig.DisabledNotificationConfig disableNotificationConfig = new NotificationConfig.DisabledNotificationConfig();
        disableNotificationConfig.setEventName("test:COMPLIANT");
        this.configurator.setDisabledNotifications(Collections.singletonList(disableNotificationConfig));
        this.configurator.initialise();
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).disableType(CompliantNotification.class);
    }

    @Test
    public void compliantDisabledNotificationByInterface() throws InitialisationException {
        ((Registry)Mockito.doReturn(Collections.singletonList(() -> Collections.singletonMap("test:COMPLIANT", new Pair(CompliantNotification.class, CompliantNotificationListener.class)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        NotificationConfig.DisabledNotificationConfig disableNotificationConfig = new NotificationConfig.DisabledNotificationConfig();
        disableNotificationConfig.setInterfaceClass(CompliantNotificationListener.class);
        this.configurator.setDisabledNotifications(Collections.singletonList(disableNotificationConfig));
        this.configurator.initialise();
        ((ServerNotificationManager)Mockito.verify((Object)this.notificationManager)).disableInterface(CompliantNotificationListener.class);
    }

    @Test
    public void nonCompliantNotification() throws InitialisationException {
        ((Registry)Mockito.doReturn(Collections.singletonList(() -> Collections.singletonMap("nonCompliant", new Pair(null, null)))).when((Object)this.registry)).lookupAllByType(NotificationsProvider.class);
        this.expected.expect(InitialisationException.class);
        this.expected.expectMessage(Matchers.containsString((String)"'nonCompliant'"));
        this.configurator.initialise();
    }

    public static class CompliantNotificationListener
    implements NotificationListener<CompliantNotification> {
        public void onNotification(CompliantNotification notification) {
        }
    }

    public static class CompliantNotification
    extends AbstractServerNotification {
        public CompliantNotification(Object message, int action) {
            super(message, action);
        }

        public String getEventName() {
            return "CompliantNotification";
        }
    }
}

