/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.dsl.model.CoreComponentBuildingDefinitionProvider;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.factories.FlowRefFactoryBean;
import org.mule.runtime.config.internal.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.processor.chain.SubflowMessageProcessorChainBuilder;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.tracer.customization.api.InitialSpanInfoProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@SmallTest
public class FlowRefFactoryBeanTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final MockSettings INITIALIZABLE_MESSAGE_PROCESSOR = Mockito.withSettings().extraInterfaces(new Class[]{Component.class, Processor.class, Initialisable.class, Disposable.class, Startable.class, Stoppable.class});
    private static final String STATIC_REFERENCED_FLOW = "staticReferencedFlow";
    private static final String DYNAMIC_REFERENCED_FLOW = "dynamicReferencedFlow";
    private static final String PARSED_DYNAMIC_REFERENCED_FLOW = "parsedDynamicReferencedFlow";
    private static final String DYNAMIC_NON_EXISTANT = "#['nonExistant']";
    private CoreEvent result;
    private final ProcessingStrategy callerFlowProcessingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
    private final Flow callerFlow = (Flow)Mockito.mock(Flow.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final Flow targetFlow = (Flow)Mockito.mock(Flow.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final LifecycleState flowLifeCycleState = (LifecycleState)Mockito.mock(LifecycleState.class);
    private final MessageProcessorChain targetSubFlow = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final Processor targetSubFlowProcessor = (Processor)Mockito.mock(Object.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
    private final SubflowMessageProcessorChainBuilder targetSubFlowChainBuilder = (SubflowMessageProcessorChainBuilder)Mockito.spy((Object)new SubflowMessageProcessorChainBuilder());
    private final ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
    private ExtendedExpressionManager expressionManager;
    private MuleContext mockMuleContext;
    @Inject
    private ConfigurationComponentLocator locator;

    @Before
    public void setup() throws MuleException {
        this.result = this.testEvent();
        this.mockMuleContext = MuleContextUtils.mockContextWithServices();
        this.mockMuleContext.getInjector().inject((Object)this);
        Mockito.when((Object)this.locator.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of((Component)Mockito.mock(Flow.class)));
        Mockito.when((Object)this.locator.find(Location.builder().globalName("flow").build())).thenReturn(Optional.of(this.callerFlow));
        Mockito.when((Object)this.callerFlow.getProcessingStrategy()).thenReturn((Object)this.callerFlowProcessingStrategy);
        Mockito.when((Object)this.callerFlowProcessingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]);
        this.expressionManager = this.mockMuleContext.getExpressionManager();
        ((ExtendedExpressionManager)Mockito.doReturn((Object)true).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)PARSED_DYNAMIC_REFERENCED_FLOW, DataType.STRING)).when((Object)this.expressionManager)).evaluate((String)ArgumentMatchers.eq((Object)DYNAMIC_REFERENCED_FLOW), (DataType)ArgumentMatchers.eq((Object)DataType.STRING), (BindingContext)ArgumentMatchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (ComponentLocation)ArgumentMatchers.any(ComponentLocation.class), ArgumentMatchers.eq((boolean)true));
        Mockito.when((Object)this.targetFlow.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.targetFlow.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        Mockito.when((Object)this.targetFlow.referenced()).thenReturn((Object)this.targetFlow);
        Mockito.when((Object)this.flowLifeCycleState.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.targetFlow.getLifecycleState()).thenReturn((Object)this.flowLifeCycleState);
        List<Processor> targetSubFlowProcessors = Collections.singletonList(this.targetSubFlowProcessor);
        Mockito.when((Object)this.targetSubFlow.getMessageProcessors()).thenReturn(targetSubFlowProcessors);
        this.targetSubFlowChainBuilder.chain(targetSubFlowProcessors);
        Mockito.when((Object)this.targetSubFlow.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.targetSubFlowProcessor.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
    }

    @Test
    public void staticFlowRefFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetFlow, null);
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, (Processor)this.targetFlow, this.applicationContext);
        this.verifyLifecycle((Processor)this.targetFlow, 0);
    }

    @Test
    public void dynamicFlowRefFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)this.targetFlow, null, this.applicationContext);
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, (Processor)this.targetFlow, this.applicationContext);
        this.verifyLifecycle((Processor)this.targetFlow, 0);
    }

    @Test
    public void staticFlowRefSubFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder);
        Assert.assertThat((Object)this.targetSubFlow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.getFlowRefProcessor(flowRefFactoryBean))));
        Assert.assertThat((Object)this.targetSubFlow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.getFlowRefProcessor(flowRefFactoryBean))));
        this.verifyProcess(flowRefFactoryBean, this.targetSubFlowProcessor, this.applicationContext);
        ((SubflowMessageProcessorChainBuilder)Mockito.verify((Object)this.targetSubFlowChainBuilder)).setProcessingStrategy((ProcessingStrategy)ArgumentMatchers.argThat(ps -> {
            ReactiveProcessor pipeline = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ReactiveProcessor processor = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ps.onProcessor(processor);
            ((ProcessingStrategy)Mockito.verify((Object)this.callerFlowProcessingStrategy)).onProcessor(processor);
            Assert.assertThat((Object)ps.onPipeline(pipeline), (Matcher)CoreMatchers.sameInstance((Object)pipeline));
            return true;
        }));
    }

    @Test
    public void dynamicFlowRefSubFlow() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder, this.applicationContext);
        Assert.assertNotSame((Object)this.targetSubFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        Assert.assertNotSame((Object)this.targetSubFlow, (Object)this.getFlowRefProcessor(flowRefFactoryBean));
        this.verifyProcess(flowRefFactoryBean, this.targetSubFlowProcessor, this.applicationContext);
        ((SubflowMessageProcessorChainBuilder)Mockito.verify((Object)this.targetSubFlowChainBuilder)).setProcessingStrategy((ProcessingStrategy)ArgumentMatchers.argThat(ps -> {
            ReactiveProcessor pipeline = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ReactiveProcessor processor = (ReactiveProcessor)Mockito.mock(ReactiveProcessor.class);
            ps.onProcessor(processor);
            ((ProcessingStrategy)Mockito.verify((Object)this.callerFlowProcessingStrategy)).onProcessor(processor);
            Assert.assertThat((Object)ps.onPipeline(pipeline), (Matcher)CoreMatchers.sameInstance((Object)pipeline));
            return true;
        }));
    }

    @Test
    @Issue(value="MULE-19272")
    public void tcclProperlySetWhenStartingStaticFlowRefSubFlow() throws Exception {
        AtomicReference startTcclRef = new AtomicReference();
        ((Startable)Mockito.doAnswer(inv -> {
            startTcclRef.set(Thread.currentThread().getContextClassLoader());
            return null;
        }).when((Object)this.targetSubFlowProcessor)).start();
        ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)Mockito.mock(ClassLoader.class)), () -> {
            try {
                FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder);
                this.verifyProcess(flowRefFactoryBean, this.targetSubFlowProcessor, this.applicationContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        Assert.assertThat((Object)((ClassLoader)startTcclRef.get()), (Matcher)CoreMatchers.sameInstance((Object)this.mockMuleContext.getExecutionClassLoader()));
    }

    @Test
    @Issue(value="MULE-19272")
    public void tcclProperlySetWhenStartingDynamicFlowRefSubFlow() throws Exception {
        AtomicReference startTcclRef = new AtomicReference();
        ((Startable)Mockito.doAnswer(inv -> {
            startTcclRef.set(Thread.currentThread().getContextClassLoader());
            return null;
        }).when((Object)this.targetSubFlowProcessor)).start();
        ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)Mockito.mock(ClassLoader.class)), () -> {
            try {
                FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)this.targetSubFlow, this.targetSubFlowChainBuilder, this.applicationContext);
                this.verifyProcess(flowRefFactoryBean, this.targetSubFlowProcessor, this.applicationContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        Assert.assertThat((Object)((ClassLoader)startTcclRef.get()), (Matcher)CoreMatchers.sameInstance((Object)this.mockMuleContext.getExecutionClassLoader()));
    }

    @Test
    public void dynamicFlowRefSubContextAware() throws Exception {
        CoreEvent event = this.testEvent();
        MuleContextAware targetMuleContextAware = (MuleContextAware)Mockito.mock(MuleContextAware.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)((Processor)targetMuleContextAware).apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)targetMuleContextAware, null, this.applicationContext);
        Assert.assertSame((Object)this.result.getMessage(), (Object)this.getFlowRefProcessor(flowRefFactoryBean).process(event).getMessage());
        ((MuleContextAware)Mockito.verify((Object)targetMuleContextAware)).setMuleContext(this.mockMuleContext);
    }

    @Test
    public void dynamicFlowRefSubFlowMessageProcessorChain() throws Exception {
        CoreEvent event = this.testEvent();
        Processor targetSubFlowConstructAware = (Processor)Mockito.mock(Object.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetSubFlowConstructAware.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        Processor targetMuleContextAwareAware = (Processor)Mockito.mock(MuleContextAware.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetMuleContextAwareAware.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]);
        Mockito.when((Object)targetSubFlowConstructAware.apply((Publisher)ArgumentMatchers.any())).thenAnswer(this.successAnswer());
        MessageProcessorChain targetSubFlowChain = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        Mockito.when((Object)targetSubFlowChain.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.result));
        List<Processor> targetSubFlowProcessors = Arrays.asList(targetSubFlowConstructAware, targetMuleContextAwareAware);
        Mockito.when((Object)targetSubFlowChain.getMessageProcessors()).thenReturn(targetSubFlowProcessors);
        SubflowMessageProcessorChainBuilder chainBuilder = new SubflowMessageProcessorChainBuilder();
        chainBuilder.chain(targetSubFlowProcessors);
        FlowRefFactoryBean flowRefFactoryBean = this.createDynamicFlowRefFactoryBean((Processor)targetSubFlowChain, chainBuilder, this.applicationContext);
        Processor flowRefProcessor = this.getFlowRefProcessor(flowRefFactoryBean);
        Mono.just((Object)event).transform((Function)flowRefProcessor).block();
        ((MuleContextAware)Mockito.verify((Object)((MuleContextAware)targetMuleContextAwareAware), (VerificationMode)Mockito.atLeastOnce())).setMuleContext(this.mockMuleContext);
    }

    private Processor getFlowRefProcessor(FlowRefFactoryBean factoryBean) throws Exception {
        Processor processor = (Processor)factoryBean.getObject();
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)this.mockMuleContext);
        return processor;
    }

    @Test
    public void dynamicFlowRefDoesNotExist() throws Exception {
        ((ExtendedExpressionManager)Mockito.doReturn((Object)new TypedValue((Object)"other", DataType.STRING)).when((Object)this.expressionManager)).evaluate((String)ArgumentMatchers.eq((Object)DYNAMIC_NON_EXISTANT), (DataType)ArgumentMatchers.eq((Object)DataType.STRING), (BindingContext)ArgumentMatchers.eq((Object)BindingContextUtils.NULL_BINDING_CONTEXT), (CoreEvent)ArgumentMatchers.any(CoreEvent.class), (ComponentLocation)ArgumentMatchers.any(ComponentLocation.class), ArgumentMatchers.eq((boolean)true));
        this.expectedException.expect(CoreMatchers.instanceOf(RoutePathNotFoundException.class));
        this.getFlowRefProcessor(this.createFlowRefFactoryBean(DYNAMIC_NON_EXISTANT, "flow", this.applicationContext)).process(this.testEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Feature(value="Core Components")
    @Story(value="Flow Reference")
    public void concurrentDynamicSubFlowInstantiation() throws Exception {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(null);
        MuleArtifactContext muleArtifactContext = (MuleArtifactContext)Mockito.spy((Object)this.createMuleArtifactContextStub((DefaultListableBeanFactory)beanFactory));
        ArrayList stubbedSubFlowProcessors = new ArrayList(2);
        AbstractBeanDefinition subFlowProcessorBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(Component.class, () -> {
            StubbedProcessor stubbedProcessor = new StubbedProcessor(this.result);
            stubbedSubFlowProcessors.add(stubbedProcessor);
            return stubbedProcessor;
        }).getBeanDefinition();
        ComponentBuildingDefinition subFlowComponentBuildingDefinition = new CoreComponentBuildingDefinitionProvider().getComponentBuildingDefinitions().stream().filter(componentBuildingDefinition -> componentBuildingDefinition.getComponentIdentifier().getName().equals("sub-flow")).findFirst().get();
        AbstractBeanDefinition subFlowBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition((Class)new ObjectFactoryClassRepository().getObjectFactoryClass(SubflowMessageProcessorChainFactoryBean.class, Object.class)).addPropertyValue("name", (Object)PARSED_DYNAMIC_REFERENCED_FLOW).addPropertyValue("messageProcessors", (Object)subFlowProcessorBeanDefinition).addPropertyValue("isSingleton", (Object)(!subFlowComponentBuildingDefinition.isPrototype() ? 1 : 0)).addPropertyValue("isPrototype", (Object)subFlowComponentBuildingDefinition.isPrototype()).addPropertyValue("isEagerInit", (Object)new LazyValue(() -> true)).setScope("prototype").getBeanDefinition();
        beanFactory.registerSingleton(InitialSpanInfoProvider.class.getName(), (Object)new DummyComponentTracerFactory());
        beanFactory.registerBeanDefinition(PARSED_DYNAMIC_REFERENCED_FLOW, (BeanDefinition)subFlowBeanDefinition);
        Flow concurrentCallerFlow = (Flow)Mockito.mock(Flow.class, (MockSettings)INITIALIZABLE_MESSAGE_PROCESSOR);
        ProcessingStrategy concurrentCallerFlowProcessingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)this.locator.find(Location.builder().globalName("concurrentFlow").build())).thenReturn(Optional.of(concurrentCallerFlow));
        Mockito.when((Object)concurrentCallerFlow.getProcessingStrategy()).thenReturn((Object)concurrentCallerFlowProcessingStrategy);
        Mockito.when((Object)concurrentCallerFlowProcessingStrategy.onProcessor((ReactiveProcessor)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]);
        FlowRefFactoryBean flowRefFactoryBean = this.createFlowRefFactoryBean(DYNAMIC_REFERENCED_FLOW, "flow", (ApplicationContext)muleArtifactContext);
        FlowRefFactoryBean parallelFlowRefFactoryBean = this.createFlowRefFactoryBean(DYNAMIC_REFERENCED_FLOW, "concurrentFlow", (ApplicationContext)muleArtifactContext);
        CountDownLatch threadCountdown = new CountDownLatch(2);
        Callable<Void> flowRefEvents = this.sendEventsThroughFlowRefAsynchronously(threadCountdown, flowRefFactoryBean);
        Callable<Void> parallelFlowRefEvents = this.sendEventsThroughFlowRefAsynchronously(threadCountdown, parallelFlowRefFactoryBean);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            executorService.invokeAll(Arrays.asList(flowRefEvents, parallelFlowRefEvents));
        }
        finally {
            executorService.shutdown();
        }
        ((ProcessingStrategy)Mockito.verify((Object)this.callerFlowProcessingStrategy, (VerificationMode)Mockito.times((int)2))).onProcessor((ReactiveProcessor)ArgumentMatchers.any());
        ((ProcessingStrategy)Mockito.verify((Object)concurrentCallerFlowProcessingStrategy, (VerificationMode)Mockito.times((int)2))).onProcessor((ReactiveProcessor)ArgumentMatchers.any());
        Assert.assertThat((Object)((Component)stubbedSubFlowProcessors.get(0)).getRootContainerLocation().getGlobalName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)((Component)stubbedSubFlowProcessors.get(1)).getRootContainerLocation().getGlobalName())));
    }

    private Callable<Void> sendEventsThroughFlowRefAsynchronously(CountDownLatch countDownLatch, FlowRefFactoryBean flowRefFactoryBean) {
        return () -> {
            try {
                countDownLatch.countDown();
                countDownLatch.await();
                this.sendEventsThroughFlowRef(flowRefFactoryBean);
            }
            catch (Exception e) {
                throw new RuntimeException("Error sending events to a flowRef", e);
            }
            return null;
        };
    }

    private void sendEventsThroughFlowRef(FlowRefFactoryBean flowRefFactoryBean) {
        try {
            Processor flowRefProcessor = this.getFlowRefProcessor(flowRefFactoryBean);
            LifecycleUtils.initialiseIfNeeded((Object)flowRefProcessor);
            LifecycleUtils.startIfNeeded((Object)flowRefProcessor);
            Assert.assertSame((Object)this.result.getMessage(), (Object)((CoreEvent)Mono.just((Object)this.newEvent()).cast(CoreEvent.class).transform((Function)flowRefProcessor).block()).getMessage());
            Assert.assertSame((Object)this.result.getMessage(), (Object)((CoreEvent)Mono.just((Object)this.newEvent()).cast(CoreEvent.class).transform((Function)flowRefProcessor).block()).getMessage());
            LifecycleUtils.stopIfNeeded((Object)flowRefProcessor);
            LifecycleUtils.disposeIfNeeded((Object)flowRefProcessor, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending events to a flowRef", e);
        }
    }

    private MuleArtifactContext createMuleArtifactContextStub(final DefaultListableBeanFactory mockedBeanFactory) {
        MuleArtifactContext muleArtifactContext = new MuleArtifactContext(this.mockMuleContext, MuleAstUtils.emptyArtifact(), (OptionalObjectsController)Mockito.mock(OptionalObjectsController.class), Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), false, ArtifactType.APP, (ComponentBuildingDefinitionRegistryFactory)new DefaultComponentBuildingDefinitionRegistryFactory(), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)){

            protected DefaultListableBeanFactory createBeanFactory() {
                return mockedBeanFactory;
            }

            protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            }

            protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerListeners() {
            }

            protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void finishRefresh() {
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }

    private FlowRefFactoryBean createFlowRefFactoryBean(String referencedFlowName, String flowRefLocation, ApplicationContext applicationContext) throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = new FlowRefFactoryBean();
        flowRefFactoryBean.setName(referencedFlowName);
        flowRefFactoryBean.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.from((String)flowRefLocation)));
        flowRefFactoryBean.setApplicationContext(applicationContext);
        this.mockMuleContext.getInjector().inject((Object)flowRefFactoryBean);
        return flowRefFactoryBean;
    }

    private FlowRefFactoryBean createStaticFlowRefFactoryBean(Processor target, Object targetBuilder) throws Exception {
        ((ExtendedExpressionManager)Mockito.doReturn((Object)false).when((Object)this.expressionManager)).isExpression(ArgumentMatchers.anyString());
        if (targetBuilder != null) {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)STATIC_REFERENCED_FLOW))).thenReturn(targetBuilder);
        } else {
            Mockito.when((Object)this.applicationContext.getBean((String)ArgumentMatchers.eq((Object)STATIC_REFERENCED_FLOW))).thenReturn((Object)target);
        }
        return this.createFlowRefFactoryBean(STATIC_REFERENCED_FLOW, "flow", this.applicationContext);
    }

    private FlowRefFactoryBean createDynamicFlowRefFactoryBean(Processor target, Object targetBuilder, ApplicationContext applicationContext) throws Exception {
        if (targetBuilder != null) {
            ((ApplicationContext)Mockito.doReturn((Object)targetBuilder).when((Object)applicationContext)).getBean((String)ArgumentMatchers.eq((Object)PARSED_DYNAMIC_REFERENCED_FLOW));
        } else {
            ((ApplicationContext)Mockito.doReturn((Object)target).when((Object)applicationContext)).getBean((String)ArgumentMatchers.eq((Object)PARSED_DYNAMIC_REFERENCED_FLOW));
        }
        return this.createFlowRefFactoryBean(DYNAMIC_REFERENCED_FLOW, "flow", applicationContext);
    }

    private Answer<?> successAnswer() {
        return invocation -> Mono.from((Publisher)((Publisher)invocation.getArgument(0))).cast(CoreEvent.class).doOnNext(event -> ((BaseEventContext)event.getContext()).success(CoreEvent.builder((CoreEvent)event).message(this.result.getMessage()).variables(this.result.getVariables()).build())).map(event -> CoreEvent.builder((CoreEvent)event).message(this.result.getMessage()).variables(this.result.getVariables()).build());
    }

    private void verifyProcess(FlowRefFactoryBean flowRefFactoryBean, Processor target, ApplicationContext applicationContext) throws Exception {
        this.sendEventsThroughFlowRef(flowRefFactoryBean);
        ((ApplicationContext)Mockito.verify((Object)applicationContext)).getBean(ArgumentMatchers.anyString());
        ((Processor)Mockito.verify((Object)target, (VerificationMode)Mockito.times((int)2))).apply((Publisher)ArgumentMatchers.any(Publisher.class));
    }

    private void verifyLifecycle(Processor target, int lifecycleRounds) throws Exception {
        ((Initialisable)Mockito.verify((Object)((Initialisable)target), (VerificationMode)Mockito.times((int)lifecycleRounds))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)lifecycleRounds))).dispose();
    }

    @Test
    public void referencedSubFlowIsStartedWhenCallerFlowIsStartedAfterStop() throws Exception {
        FlowRefFactoryBean flowRefFactoryBean = this.createStaticFlowRefFactoryBean((Processor)this.targetSubFlow, null);
        Processor flowRefProcessor = flowRefFactoryBean.doGetObject();
        flowRefProcessor.process(this.testEvent());
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
        LifecycleUtils.stopIfNeeded((Object)flowRefProcessor);
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
        LifecycleUtils.startIfNeeded((Object)flowRefProcessor);
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)2))).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)1))).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.targetSubFlow, (VerificationMode)Mockito.times((int)0))).dispose();
    }

    private static class StubbedProcessor
    extends AbstractComponent
    implements Processor {
        private final CoreEvent applyResult;

        public StubbedProcessor(CoreEvent applyResult) {
            this.applyResult = applyResult;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new RuntimeException(new IllegalAccessException("This method should never be called"));
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Mono.from(publisher).doOnNext(event -> ((BaseEventContext)event.getContext()).success(CoreEvent.builder((CoreEvent)event).message(this.applyResult.getMessage()).variables(this.applyResult.getVariables()).build())).map(event -> CoreEvent.builder((CoreEvent)event).message(this.applyResult.getMessage()).variables(this.applyResult.getVariables()).build());
        }
    }
}

