/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import io.qameta.allure.Issue;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.CreateParamBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.SimpleTypeBeanParamDefinitionCreator;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SimpleTypeBeanParamDefinitionCreatorTestCase
extends AbstractMuleTestCase {
    private ParameterModel paramModel;
    private SimpleTypeBeanParamDefinitionCreator simpleTypeParamDefinitionCreator;
    private CreateParamBeanDefinitionRequest createParamDefinitionRequest;
    private Map<ComponentAst, SpringComponentModel> springComponentModels;

    @Before
    public void setUp() {
        this.paramModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.paramModel.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        this.simpleTypeParamDefinitionCreator = new SimpleTypeBeanParamDefinitionCreator(true, true);
        this.createParamDefinitionRequest = (CreateParamBeanDefinitionRequest)Mockito.mock(CreateParamBeanDefinitionRequest.class);
        SpringComponentModel springComponentModel = new SpringComponentModel();
        Mockito.when((Object)this.createParamDefinitionRequest.getSpringComponentModel()).thenReturn((Object)springComponentModel);
        Mockito.when((Object)this.createParamDefinitionRequest.getComponentBuildingDefinition()).thenReturn((Object)((ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class)));
    }

    @Test
    @Issue(value="W-17475148")
    public void complexObjectFromExpression() {
        SpringComponentModel springComponentModel = this.createParamDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(Map.class);
        ComponentParameterAst param = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)param.getValue()).thenReturn((Object)Either.left((Object)"'some DW expression'"));
        Mockito.when((Object)this.createParamDefinitionRequest.getParam()).thenReturn((Object)param);
        boolean result = this.simpleTypeParamDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createParamDefinitionRequest);
        MatcherAssert.assertThat((String)"request not handled when it must", (Object)result, (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="W-17475148")
    public void complexObjectInlineNotHandled() {
        SpringComponentModel springComponentModel = this.createParamDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(Map.class);
        ComponentParameterAst param = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)param.getValue()).thenReturn((Object)Either.right((Object)Mockito.mock(ComponentAst.class)));
        ParameterModel paramModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)paramModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)param.getModel()).thenReturn((Object)paramModel);
        Mockito.when((Object)this.createParamDefinitionRequest.getParam()).thenReturn((Object)param);
        boolean result = this.simpleTypeParamDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createParamDefinitionRequest);
        MatcherAssert.assertThat((String)"request handled when it must not", (Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="W-17475148")
    public void staticTextInContentParamHandled() {
        SpringComponentModel springComponentModel = this.createParamDefinitionRequest.getSpringComponentModel();
        springComponentModel.setType(Map.class);
        ComponentParameterAst param = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)param.getValue()).thenReturn((Object)Either.right((Object)"some static text"));
        ParameterModel paramModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)paramModel.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        Mockito.when((Object)param.getModel()).thenReturn((Object)paramModel);
        Mockito.when((Object)this.createParamDefinitionRequest.getParam()).thenReturn((Object)param);
        boolean result = this.simpleTypeParamDefinitionCreator.handleRequest(this.springComponentModels, (CreateBeanDefinitionRequest)this.createParamDefinitionRequest);
        MatcherAssert.assertThat((String)"request not handled when it must", (Object)result, (Matcher)Matchers.is((Object)true));
    }
}

