/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Issue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.internal.SpringXmlConfigurationBuilder;
import org.mule.runtime.config.internal.context.BaseSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.lazy.LazyExpressionLanguageAdaptor;
import org.mule.runtime.config.internal.registry.BaseSpringRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.el.ExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.MuleContextUtils;

public class SpringXmlConfigurationBuilderTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    public static final String SCHEMA_VALIDATION_ERROR = "Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing";
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private SpringXmlConfigurationBuilder configurationBuilderWithUsedInvalidSchema;
    private SpringXmlConfigurationBuilder configurationBuilderWitUnusedInvalidSchema;
    private MuleContextWithRegistry muleContext;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty disableExpressionsSupport = new SystemProperty(BaseSpringMuleContextServiceConfigurator.DISABLE_TRANSFORMERS_SUPPORT, "true");

    @BeforeClass
    public static void configureTestSchemaLoader() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field schemaGeneratorField = AstXmlParser.Builder.class.getDeclaredField("SCHEMA_GENERATOR");
        schemaGeneratorField.setAccessible(true);
        schemaGeneratorField.set(null, Optional.of(new TestExtensionSchemagenerator()));
    }

    @Before
    public void setUp() throws Exception {
        this.muleContext = MuleContextUtils.mockContextWithServices();
        MuleContextUtils.addExtensionModelToMock((MuleContext)this.muleContext, (ExtensionModel)MuleExtensionModelProvider.getExtensionModel());
        this.muleContext.getInjector().inject((Object)this);
        this.configurationBuilderWithUsedInvalidSchema = new SpringXmlConfigurationBuilder(new String[]{"invalid-schema.xml"}, new HashMap(), ArtifactType.APP, false, false);
        this.configurationBuilderWitUnusedInvalidSchema = new SpringXmlConfigurationBuilder(new String[]{"invalid-schema-not-used.xml"}, new HashMap(), ArtifactType.APP, false, false);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailOnFirstError() throws ConfigurationException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)SCHEMA_VALIDATION_ERROR));
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)true);
        this.configurationBuilderWithUsedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailAfterTenErrors() throws ConfigurationException {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)SCHEMA_VALIDATION_ERROR));
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)false);
        this.configurationBuilderWithUsedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    @Test
    @Issue(value="MULE-19534")
    public void configureWithFailAfterTenErrorsWillSucceedIfSchemaNotUsed() throws ConfigurationException {
        Mockito.when((Object)this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)).thenReturn((Object)false);
        this.configurationBuilderWitUnusedInvalidSchema.configure((MuleContext)this.muleContext);
    }

    @Test
    @Issue(value="MULE-19791")
    public void configureWithResourceOutsideClasspathPreservesResourceName() throws ConfigurationException, IOException {
        this.copyResourceToTemp("simple.xml");
        SpringXmlConfigurationBuilder configurationBuilder = this.xmlConfigurationBuilderRelativeToPath(this.tempFolder.getRoot(), new String[]{"simple.xml"}, false);
        configurationBuilder.configure((MuleContext)this.muleContext);
        ArtifactContext artifactContext = configurationBuilder.createArtifactContext();
        ArtifactAst artifactAst = artifactContext.getArtifactAst();
        ComponentAst componentAst = (ComponentAst)artifactAst.topLevelComponents().get(0);
        MatcherAssert.assertThat((Object)componentAst.getMetadata().getFileName(), (Matcher)Matchers.is(Optional.of("simple.xml")));
    }

    @Test
    @Issue(value="W-11745207")
    public void baseRegistryWithLazyInitialisation() throws Exception {
        this.doTestBaseRegistryExpressionLanguageAdapter(true, LazyExpressionLanguageAdaptor.class);
    }

    @Test
    @Issue(value="W-11745207")
    public void baseRegistryWithEagerInitialisation() throws Exception {
        this.doTestBaseRegistryExpressionLanguageAdapter(false, DataWeaveExpressionLanguageAdaptor.class);
    }

    private void doTestBaseRegistryExpressionLanguageAdapter(boolean lazyInit, Class expectedClass) throws IOException, ConfigurationException {
        SpringXmlConfigurationBuilder configurationBuilder = this.xmlConfigurationBuilderRelativeToPath(this.tempFolder.getRoot(), new String[]{"simple.xml"}, lazyInit);
        ArgumentCaptor registryCaptor = ArgumentCaptor.forClass(Registry.class);
        configurationBuilder.configure((MuleContext)this.muleContext);
        ((MuleContextWithRegistry)Mockito.verify((Object)this.muleContext, (VerificationMode)Mockito.atLeastOnce())).setRegistry((Registry)registryCaptor.capture());
        List registries = registryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)((Registry)registries.get(0)), (Matcher)IsInstanceOf.instanceOf(BaseSpringRegistry.class));
        BaseSpringRegistry baseSpringRegistry = (BaseSpringRegistry)registries.get(0);
        ExpressionLanguageAdaptor dataWeaveExpressionLanguageAdaptor = (ExpressionLanguageAdaptor)baseSpringRegistry.get("_muleDwExpressionLanguageAdapter");
        MatcherAssert.assertThat((Object)dataWeaveExpressionLanguageAdaptor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)dataWeaveExpressionLanguageAdaptor, (Matcher)IsInstanceOf.instanceOf((Class)expectedClass));
    }

    @Test
    public void memoryManagementCanBeInjectedInBean() throws MuleException, IOException {
        this.copyResourceToTemp("simple.xml");
        SpringXmlConfigurationBuilder configurationBuilder = this.xmlConfigurationBuilderRelativeToPath(this.tempFolder.getRoot(), new String[]{"simple.xml"}, false);
        configurationBuilder.configure((MuleContext)this.muleContext);
        ArtifactContext artifactContext = configurationBuilder.createArtifactContext();
        MemoryManagementInjected memoryManagementInjected = new MemoryManagementInjected();
        artifactContext.getMuleContext().getInjector().inject((Object)memoryManagementInjected);
        MatcherAssert.assertThat((Object)memoryManagementInjected.getMemoryManagementService(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private void copyResourceToTemp(String resourceName) throws IOException {
        URL originalResource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        File simpleAppFileOutsideClassPath = new File(this.tempFolder.getRoot(), resourceName);
        MatcherAssert.assertThat((Object)originalResource, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        FileUtils.copyURLToFile((URL)originalResource, (File)simpleAppFileOutsideClassPath);
    }

    private SpringXmlConfigurationBuilder xmlConfigurationBuilderRelativeToPath(File basePath, String[] resources, boolean enableLazyInit) throws IOException {
        return (SpringXmlConfigurationBuilder)ClassUtils.withContextClassLoader((ClassLoader)new URLClassLoader(new URL[]{basePath.toURI().toURL()}, null), () -> new SpringXmlConfigurationBuilder(resources, Collections.emptyMap(), ArtifactType.APP, enableLazyInit, false));
    }

    private static class MemoryManagementInjected {
        @Inject
        private MemoryManagementService memoryManagementService;

        private MemoryManagementInjected() {
        }

        public MemoryManagementService getMemoryManagementService() {
            return this.memoryManagementService;
        }
    }

    public static final class TestExtensionSchemagenerator
    implements ExtensionSchemaGenerator {
        public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
            return "";
        }
    }
}

