/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.internal.ArtifactAstConfigurationBuilder;
import org.mule.runtime.config.internal.error.MuleCoreErrorTypeRepository;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.MockExtensionManagerConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Features(value={@Feature(value="Mule Artifact AST"), @Feature(value="Registry")})
@Story(value="Object Registration")
@RunWith(value=Parameterized.class)
public class ArtifactAstInRegistryTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAstInRegistryTestCase.class);
    @Parameterized.Parameter(value=0)
    public Boolean addArtifactAstToRegistry;
    @Parameterized.Parameter(value=1)
    public Boolean lazyInit;
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private ArtifactAst artifactAst;
    private MuleContextWithRegistry muleContext;

    @Parameterized.Parameters(name="addArtifactAstToRegistry: {0}; lazyInit: {1}")
    public static List<Boolean[]> params() {
        return Arrays.asList({false, false}, {true, false}, {false, true}, {true, true});
    }

    @Before
    public void before() throws Exception {
        this.artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)this.artifactAst.getArtifactName()).thenReturn((Object)"my mock ast");
        Mockito.when((Object)this.artifactAst.getArtifactType()).thenReturn((Object)org.mule.runtime.ast.api.ArtifactType.APPLICATION);
        Mockito.when((Object)this.artifactAst.getErrorTypeRepository()).thenReturn((Object)MuleCoreErrorTypeRepository.MULE_CORE_ERROR_TYPE_REPOSITORY);
        ArtifactAstConfigurationBuilder artifactAstConfigurationBuilder = new ArtifactAstConfigurationBuilder(this.artifactAst, Collections.singletonMap("mule.application.deployment.addArtifactAstToRegistry", this.addArtifactAstToRegistry.toString()), ArtifactType.APP, this.lazyInit.booleanValue(), false);
        this.muleContext = (MuleContextWithRegistry)new DefaultMuleContextFactory().createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new MockExtensionManagerConfigurationBuilder(), artifactAstConfigurationBuilder});
        this.muleContext.start();
    }

    @After
    public void after() {
        if (this.muleContext != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.muleContext, (Logger)LOGGER);
        }
    }

    @Test
    public void artifactAstAvailableInRegistryIfEnabled() {
        ArtifactAst actualArtifactAst = (ArtifactAst)this.muleContext.getRegistry().lookupObject("_muleArtifactAst");
        if (this.addArtifactAstToRegistry.booleanValue()) {
            Assert.assertThat((Object)actualArtifactAst.getArtifactName(), (Matcher)Matchers.is((Object)"my mock ast"));
        } else {
            Assert.assertThat((Object)actualArtifactAst, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }
}

