/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.config.internal.factories.TryProcessorFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transaction.DelegateTransactionFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.processor.TryScope;
import org.mule.runtime.core.internal.registry.SimpleRegistry;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;

public class TryProcessorFactoryBeanTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private final MuleContextWithRegistry muleContextMock = MuleContextUtils.mockContextWithServices();
    private SimpleRegistry registry;

    @Before
    public void setUp() throws RegistrationException {
        this.registry = new SimpleRegistry((MuleContext)this.muleContextMock, (LifecycleInterceptor)new MuleLifecycleInterceptor());
        this.registry.registerObject("txFactory", (Object)new TransactionFactoryLocator());
    }

    @Test
    public void doesNotFailWithNoProcessors() throws Exception {
        TryProcessorFactoryBean tryProcessorFactoryBean = new TryProcessorFactoryBean();
        tryProcessorFactoryBean.setTransactionalAction("INDIFFERENT");
        tryProcessorFactoryBean.setTransactionType(TransactionType.LOCAL);
        HashMap<QName, Object> annotations = new HashMap<QName, Object>();
        annotations.put(AbstractComponent.LOCATION_KEY, new DefaultComponentLocation(Optional.of("root"), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("root", Optional.of(TypedComponentIdentifier.builder().identifier((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)).type(TypedComponentIdentifier.ComponentType.FLOW).build()), Optional.empty(), OptionalInt.empty(), OptionalInt.empty()))));
        annotations.put(AbstractComponent.ROOT_CONTAINER_NAME_KEY, "root");
        tryProcessorFactoryBean.setAnnotations(annotations);
        this.registry.inject((Object)tryProcessorFactoryBean);
        TryScope tryMessageProcessor = tryProcessorFactoryBean.getObject();
        Mockito.when((Object)this.muleContextMock.getConfiguration().getDefaultTransactionTimeout()).thenReturn((Object)30000);
        LifecycleUtils.initialiseIfNeeded((Object)tryMessageProcessor, (MuleContext)this.muleContextMock);
        tryMessageProcessor.start();
        MuleTransactionConfig transactionConfig = tryMessageProcessor.getTransactionConfig();
        Assert.assertThat((Object)transactionConfig.getFactory(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DelegateTransactionFactory.class)));
        Assert.assertThat((Object)transactionConfig.getTimeout(), (Matcher)Matchers.is((Object)30000));
    }
}

