/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.config.internal.registry.SpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Feature(value="Registry")
@Story(value="Object Registration")
public class SpringRegistryTestCase
extends AbstractMuleTestCase {
    private ConfigurableApplicationContext appContext;
    private DefaultListableBeanFactory beanFactory;

    @Before
    public void setUp() {
        this.appContext = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        this.beanFactory = (DefaultListableBeanFactory)Mockito.mock(DefaultListableBeanFactory.class);
        Mockito.when((Object)this.appContext.getBeanFactory()).thenReturn((Object)this.beanFactory);
    }

    @Test
    @Issue(value="MULE-20042")
    public void unregisterBeanWhoseCreationFails() throws RegistrationException {
        SpringRegistry registry = new SpringRegistry((ApplicationContext)this.appContext, (ApplicationContext)this.appContext, (MuleContext)Mockito.mock(MuleContext.class), (ConfigurationDependencyResolver)Mockito.mock(ConfigurationDependencyResolver.class), (LifecycleInterceptor)Mockito.mock(LifecycleInterceptor.class));
        Mockito.when((Object)this.beanFactory.containsBeanDefinition("key")).thenReturn((Object)true);
        Mockito.when((Object)this.appContext.getBean("key")).thenThrow(BeanCreationException.class);
        MatcherAssert.assertThat((Object)registry.unregisterObject("key"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory)).removeBeanDefinition("key");
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory)).destroySingleton("key");
    }
}

