/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.utils.Utils;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class InjectParamsFromContextServiceProxyTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Inject
    private Registry registry;

    protected boolean doTestClassInjection() {
        return true;
    }

    @Test
    public void notAugmentedInvocation() {
        Utils.BasicService service = new Utils.BasicService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedInvocation() {
        Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassInvocation() {
        Utils.AugmentedSubclassMethodService service = new Utils.AugmentedSubclassMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void augmentedSubclassOverridesInvocation() {
        Utils.AugmentedSubclassOverridesMethodService service = new Utils.AugmentedSubclassOverridesMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void augmentedWithPreferredInvocation() throws Exception {
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"myBean", (Object)new Utils.MyBean());
        Utils.MyPreferredBean preferredBean = new Utils.MyPreferredBean();
        LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)"myPreferredBean", (Object)preferredBean);
        Utils.AugmentedWithPreferredMethodService service = new Utils.AugmentedWithPreferredMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)preferredBean));
    }

    @Test
    public void namedAugmentedInvocation() {
        Utils.NamedAugmentedMethodService service = new Utils.NamedAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void invalidNamedAugmentedInvocation() {
        Utils.InvalidNamedAugmentedMethodService service = new Utils.InvalidNamedAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        this.expected.expect(IllegalDependencyInjectionException.class);
        this.expected.expectMessage(String.format("No object found in the registry for parameter '%s' of method '%s' in service '%s'", "param", "augmented", "InvalidNamedAugmentedMethodService"));
        serviceProxy.augmented();
    }

    @Test
    public void hiddenAugmentedInvocation() {
        Utils.HiddenAugmentedMethodService service = new Utils.HiddenAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation() {
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        Utils.BaseOverloadedService serviceProxy = (Utils.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void overloadedAugmentedInvocation2() {
        Utils.OverloadedAugmentedMethodService service = new Utils.OverloadedAugmentedMethodService();
        Utils.BaseOverloadedService serviceProxy = (Utils.BaseOverloadedService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(1);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void overloadedAugmentedInvocation3() {
        Utils.OverloadedAugmentedMethodService2 service = new Utils.OverloadedAugmentedMethodService2();
        Utils.BaseOverloadedService2 serviceProxy = (Utils.BaseOverloadedService2)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented(muleContext, 1);
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }

    @Test
    public void ambiguousAugmentedInvocation() {
        Utils.AmbiguousAugmentedMethodService service = new Utils.AmbiguousAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        this.expected.expect(IllegalDependencyInjectionException.class);
        this.expected.expectMessage(String.format("More than one invocation candidate for method '%s' in service '%s'", "augmented", "AmbiguousAugmentedMethodService"));
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.nullValue());
    }

    @Test
    public void invalidAugmentedInvocation() {
        Utils.InvalidAugmentedMethodService service = new Utils.InvalidAugmentedMethodService();
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)service, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void throughProxyAugmentedInvocation() {
        final Utils.AugmentedMethodService service = new Utils.AugmentedMethodService();
        MetadataInvocationHandler noOpHandler = new MetadataInvocationHandler(service){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)service, args);
            }
        };
        Utils.BaseService innerProxy = (Utils.BaseService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{Utils.BaseService.class}, (InvocationHandler)noOpHandler);
        Utils.BaseService serviceProxy = (Utils.BaseService)InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)innerProxy, (Registry)this.registry);
        serviceProxy.augmented();
        Assert.assertThat((Object)Utils.augmentedParam, (Matcher)Matchers.sameInstance((Object)muleContext));
    }
}

