/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.lazy.AbstractLazyMuleArtifactContextTestCase;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ResolvableType;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
@RunWith(value=Parameterized.class)
public class LazyMuleArtifactContextBeanFactoryTestCase
extends AbstractLazyMuleArtifactContextTestCase {
    @Parameterized.Parameter
    public boolean beanFactoryMustThrow;
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private static final String ANOTHER_FLOW = "anotherFlow";
    private final AtomicInteger initializations = new AtomicInteger(0);
    private final FakeBeanFactoryDefaultAnswer beanFactoryDefaultAnswer = new FakeBeanFactoryDefaultAnswer();

    @Parameterized.Parameters(name="BeanFactory throws NoSuchBeanDefinition: {0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.beanFactoryDefaultAnswer.setBeanFactoryMustThrow(this.beanFactoryMustThrow);
    }

    @Test
    public void whenBeanFactoryThrowsThenThrows() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        ((DefaultListableBeanFactory)Mockito.doThrow(NoSuchBeanDefinitionException.class).when((Object)this.beanFactory)).getBean("non-existent");
        this.expectedException.expect(NoSuchBeanDefinitionException.class);
        this.lazyMuleArtifactContext.getBean("non-existent");
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory, (VerificationMode)Mockito.never())).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"non-existent"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Test
    public void whenBeanFactoryDoesNotThrowThenDontThrow() {
        ((DefaultListableBeanFactory)Mockito.doReturn(null).when((Object)this.beanFactory)).getBean("non-existent");
        MatcherAssert.assertThat((Object)this.lazyMuleArtifactContext.getBean("non-existent"), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory, (VerificationMode)Mockito.never())).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"non-existent"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Test
    public void whenInitializationIsNotDoneYetThenShouldNotCreateBeansOnLookup() {
        if (this.beanFactoryMustThrow) {
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean("myFlow"), NoSuchBeanDefinitionException.class);
        } else {
            this.lazyMuleArtifactContext.getBean("myFlow");
        }
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)0));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory, (VerificationMode)Mockito.never())).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"myFlow"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Test
    public void whenInitializationIsDoneThenShouldCreateBeansOnLookup() {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        this.lazyMuleArtifactContext.getBean("myFlow");
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"myFlow"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Test
    public void whenBeanAlreadyInitializedThenShouldNotDoItAgain() {
        Location location = Location.builderFromStringRepresentation((String)"myFlow").build();
        this.lazyMuleArtifactContext.initializeComponent(location);
        this.lazyMuleArtifactContext.getBean("myFlow");
        this.lazyMuleArtifactContext.getBean("myFlow");
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"myFlow"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Test
    public void whenCallingOperationsNotSupportingAutomaticInitializationBeforeInitializationThenDelegates() {
        if (this.beanFactoryMustThrow) {
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean("myFlow", new Object[]{1}), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean(Object.class), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBean(Object.class, new Object[]{1}), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBeanProvider(Object.class), NoSuchBeanDefinitionException.class);
            this.verifyException(() -> this.lazyMuleArtifactContext.getBeanProvider(ResolvableType.forClass(Object.class)), NoSuchBeanDefinitionException.class);
        } else {
            this.lazyMuleArtifactContext.getBean("myFlow", new Object[]{1});
            this.lazyMuleArtifactContext.getBean(Object.class);
            this.lazyMuleArtifactContext.getBean(Object.class, new Object[]{1});
            this.lazyMuleArtifactContext.getBeanProvider(Object.class);
            this.lazyMuleArtifactContext.getBeanProvider(ResolvableType.forClass(Object.class));
        }
    }

    @Test
    public void whenCallingOperationsNotSupportingAutomaticInitializationAfterInitializationThenDelegates() {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        this.whenCallingOperationsNotSupportingAutomaticInitializationBeforeInitializationThenDelegates();
    }

    @Test
    public void whenCallingGetBeanTypeSafeThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getBean("myFlow", Object.class));
    }

    @Test
    public void whenCallingContainsBeanThenBeanIsInitialized() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.containsBean("myFlow"));
    }

    @Test
    public void whenCallingIsSingletonThenBeanIsInitialized() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.isSingleton("myFlow"));
    }

    @Test
    public void whenCallingIsPrototypeThenBeanIsInitialized() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.isPrototype("myFlow"));
    }

    @Test
    public void whenCallingIsTypeMatchThenBeanIsInitialized() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.isTypeMatch("myFlow", Object.class));
    }

    @Test
    public void whenCallingIsTypeMatchResolvableTypeThenBeanIsInitialized() {
        Assume.assumeThat((Object)this.beanFactoryMustThrow, (Matcher)Is.is((Object)true));
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.isTypeMatch("myFlow", ResolvableType.forClass(Object.class)));
    }

    @Test
    public void whenCallingGetTypeThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getType("myFlow"));
    }

    @Test
    public void whenCallingGetTypeAllowFactoryBeanInitThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getType("myFlow", true));
    }

    @Test
    public void whenCallingGetAliasesThenBeanIsInitialized() {
        this.verifyInitialized(() -> this.lazyMuleArtifactContext.getAliases("myFlow"));
    }

    private void verifyUnsupportedOperationException(Runnable runnable) {
        this.verifyException(runnable, UnsupportedOperationException.class);
    }

    private void verifyException(Runnable runnable, Class<? extends Throwable> throwableCls) {
        Matcher matcher = CoreMatchers.instanceOf(throwableCls);
        try {
            runnable.run();
            Assert.fail((String)String.format("Expected test to throw: %s", matcher));
        }
        catch (Throwable t) {
            MatcherAssert.assertThat((Object)t, (Matcher)matcher);
        }
    }

    private void verifyInitialized(Runnable runnable) {
        this.lazyMuleArtifactContext.initializeComponent(Location.builderFromStringRepresentation((String)ANOTHER_FLOW).build());
        runnable.run();
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
        ((DefaultListableBeanFactory)Mockito.verify((Object)this.beanFactory)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"myFlow"), (BeanDefinition)ArgumentMatchers.any());
    }

    @Override
    protected ArtifactDeclaration getArtifactDeclaration() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName("myFlow").getDeclaration()).withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(ANOTHER_FLOW).getDeclaration()).getDeclaration();
    }

    @Override
    protected void onProcessorInitialization() {
        this.initializations.incrementAndGet();
    }

    @Override
    protected DefaultListableBeanFactory doCreateBeanFactoryMock() {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)Mockito.mock(ObjectProviderAwareBeanFactory.class, (Answer)this.beanFactoryDefaultAnswer);
        ((DefaultListableBeanFactory)Mockito.doAnswer(this.beanFactoryDefaultAnswer.getAnswerForRegisterBeanDefinition()).when((Object)beanFactory)).registerBeanDefinition((String)ArgumentMatchers.any(), (BeanDefinition)ArgumentMatchers.any());
        return beanFactory;
    }

    private static class FakeBeanFactoryDefaultAnswer
    implements Answer<Object> {
        private boolean beanFactoryMustThrow = false;
        private final Set<String> registeredBeans = new HashSet<String>();

        private FakeBeanFactoryDefaultAnswer() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (!this.beanFactoryMustThrow || !FakeBeanFactoryDefaultAnswer.isMethodFromBeanFactoryInterface(invocation.getMethod())) {
                return Mockito.RETURNS_DEFAULTS.answer(invocation);
            }
            if (invocation.getArgument(0) instanceof Class) {
                throw new NoSuchBeanDefinitionException((Class)invocation.getArgument(0, Class.class));
            }
            if (invocation.getArgument(0) instanceof ResolvableType) {
                throw new NoSuchBeanDefinitionException((ResolvableType)invocation.getArgument(0, ResolvableType.class));
            }
            if (this.registeredBeans.contains(invocation.getArgument(0, String.class))) {
                return Mockito.RETURNS_DEFAULTS.answer(invocation);
            }
            throw new NoSuchBeanDefinitionException((String)invocation.getArgument(0, String.class));
        }

        public Answer<?> getAnswerForRegisterBeanDefinition() {
            return invocation -> {
                this.registeredBeans.add((String)invocation.getArgument(0, String.class));
                return null;
            };
        }

        public void setBeanFactoryMustThrow(boolean beanFactoryMustThrow) {
            this.beanFactoryMustThrow = beanFactoryMustThrow;
        }

        private static boolean isMethodFromBeanFactoryInterface(Method method) {
            try {
                BeanFactory.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    }
}

