/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import com.google.common.collect.ImmutableSet;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.dsl.model.AbstractDslModelTestCase;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.context.lazy.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.el.function.MuleFunctionsBindingContextProvider;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.tck.util.MuleContextUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
public abstract class AbstractLazyMuleArtifactContextTestCase
extends AbstractDslModelTestCase {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    protected LazyMuleArtifactContext lazyMuleArtifactContext;
    protected static final String MY_FLOW = "myFlow";
    @Mock(extraInterfaces={Initialisable.class, Disposable.class, Startable.class, Stoppable.class})
    protected Processor targetProcessor;
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private InternalCustomizationService customizationService;
    @Mock
    private OptionalObjectsController optionalObjectsController;
    @Mock
    private LockFactory lockFactory;
    protected DefaultListableBeanFactory beanFactory;

    @Before
    public void setup() throws Exception {
        MuleContextWithRegistry muleContext = MuleContextUtils.mockContextWithServices();
        ImmutableSet extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        MuleRegistry mockedRegistry = muleContext.getRegistry();
        Mockito.when((Object)this.extensionManager.getExtensions()).thenReturn((Object)extensions);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)muleContext.getExtensionManager()).thenReturn((Object)this.extensionManager);
        Mockito.when((Object)muleContext.getCustomizationService()).thenReturn((Object)this.customizationService);
        Mockito.when((Object)mockedRegistry.get("_muleRegistry")).thenReturn((Object)new DefaultRegistry((MuleContext)muleContext));
        Mockito.when((Object)mockedRegistry.get("core.global.binding.provider")).thenReturn(Mockito.mock(MuleFunctionsBindingContextProvider.class));
        this.lazyMuleArtifactContext = this.createLazyMuleArtifactContextStub(muleContext);
        DefaultMessageProcessorChainBuilder messageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.targetProcessor});
        Mockito.when((Object)mockedRegistry.lookupObject(MY_FLOW)).thenReturn((Object)messageProcessorChainBuilder);
        ((Initialisable)Mockito.doAnswer(a -> {
            this.onProcessorInitialization();
            return null;
        }).when((Object)((Initialisable)this.targetProcessor))).initialise();
    }

    protected abstract void onProcessorInitialization();

    protected abstract ArtifactDeclaration getArtifactDeclaration();

    protected DefaultListableBeanFactory doCreateBeanFactoryMock() {
        return (DefaultListableBeanFactory)Mockito.mock(ObjectProviderAwareBeanFactory.class);
    }

    private DefaultListableBeanFactory createBeanFactoryMock() {
        DefaultListableBeanFactory beanFactory = this.doCreateBeanFactoryMock();
        ((DefaultListableBeanFactory)Mockito.doReturn((Object)"mutex").when((Object)beanFactory)).getSingletonMutex();
        ((DefaultListableBeanFactory)Mockito.doReturn((Object)new String[0]).when((Object)beanFactory)).getBeanNamesForType((Class)ArgumentMatchers.any(Class.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((DefaultListableBeanFactory)Mockito.doNothing().when((Object)beanFactory)).setSerializationId((String)ArgumentMatchers.any(String.class));
        return beanFactory;
    }

    @Override
    protected ExtensionModel createExtension(String name, XmlDslModel xmlDslModel, List<ConfigurationModel> configs, List<ConnectionProviderModel> connectionProviders) {
        return new ImmutableExtensionModel("extension", "", "1.0", "Mulesoft", Category.COMMUNITY, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, xmlDslModel, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private LazyMuleArtifactContext createLazyMuleArtifactContextStub(MuleContextWithRegistry muleContext) {
        LazyMuleArtifactContext muleArtifactContext = new LazyMuleArtifactContext((MuleContext)muleContext, ArtifactDeclarationUtils.toArtifactast((ArtifactDeclaration)this.getArtifactDeclaration(), this.getExtensions(muleContext.getExtensionManager())), this.optionalObjectsController, Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), false, ArtifactType.APP, Optional.empty(), this.lockFactory, (ComponentBuildingDefinitionRegistryFactory)new DefaultComponentBuildingDefinitionRegistryFactory(), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)){

            protected DefaultListableBeanFactory createBeanFactory() {
                AbstractLazyMuleArtifactContextTestCase.this.beanFactory = AbstractLazyMuleArtifactContextTestCase.this.createBeanFactoryMock();
                return AbstractLazyMuleArtifactContextTestCase.this.beanFactory;
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }
}

