/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Rule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.dsl.model.ComplexActingParameter;
import org.mule.runtime.config.dsl.model.ComplexActingParameterUtils;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMockedValueProviderExtensionTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMockedValueProviderExtensionTestCase.class);
    protected static final String NAMESPACE = "vp-mockns";
    protected static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/vp-mockns";
    protected static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/vp-mockns/current/vp-mule-mockns.xsd";
    protected static final String PARAMETER_IN_GROUP_NAME = "parameterInGroup";
    protected static final String PARAMETER_IN_GROUP_DEFAULT_VALUE = "parameterInGroup";
    protected static final String CUSTOM_PARAMETER_GROUP_NAME = "customParameterGroupName";
    protected static final String ACTING_PARAMETER_NAME = "actingParameter";
    protected static final String ACTING_PARAMETER_DEFAULT_VALUE = "actingParameter";
    protected static final String PARAMETER_REQUIRED_FOR_METADATA_NAME = "requiredForMetadata";
    protected static final String PARAMETER_REQUIRED_FOR_METADATA_DEFAULT_VALUE = "requiredForMetadata";
    protected static final String PROVIDED_PARAMETER_NAME = "providedParameter";
    protected static final String OTHER_PROVIDED_PARAMETER_NAME = "otherProvidedParameter";
    protected static final String PROVIDED_FROM_COMPLEX_PARAMETER_NAME = "fromComplexActingParameter";
    protected static final String COMPLEX_ACTING_PARAMETER_NAME = "complexActingParameter";
    protected static final String PROVIDED_PARAMETER_DEFAULT_VALUE = "providedParameter";
    protected static final String EXTENSION_NAME = "extension";
    protected static final String OPERATION_NAME = "mockOperation";
    protected static final String OTHER_OPERATION_NAME = "mockOtherOperation";
    protected static final String SOURCE_NAME = "source";
    protected static final String CONFIGURATION_NAME = "configuration";
    protected static final String OTHER_CONFIGURATION_NAME = "otherConfiguration";
    protected static final String CONNECTION_PROVIDER_NAME = "connection";
    protected static final String VALUE_PROVIDER_NAME = "valueProvider";
    protected static final String VALUE_PROVIDER_ID = "valueProviderId";
    protected static final String COMPLEX_VALUE_PROVIDER_NAME = "complexValueProvider";
    protected static final String COMPLEX_VALUE_PROVIDER_ID = "complexValueProviderId";
    protected static final String FIELD_VALUE_PROVIDER_NAME = "fieldValueProvider";
    protected static final String FIELD_VALUE_PROVIDER_ID = "fieldValueProviderId";
    protected static final String MY_FLOW = "myFlow";
    protected static final String MY_CONFIG = "myConfig";
    protected static final String MY_CONNECTION = "myConfig/connection";
    protected static final String SOURCE_LOCATION = "myFlow/source";
    protected static final String OPERATION_LOCATION = "myFlow/processors/0";
    protected static final String OTHER_OPERATION_LOCATION = "myFlow/processors/1";
    @Rule
    public MockitoRule mockito = MockitoJUnit.rule();
    @Mock(lenient=true)
    protected ExtensionModel mockExtension;
    protected ConfigurationModel configuration;
    protected ConfigurationModel otherConfiguration;
    protected OperationModel operation;
    protected OperationModel otherOperation;
    protected ConnectionProviderModel connectionProvider;
    protected SourceModel source;
    protected ParameterModel parameterInGroup;
    protected ParameterGroupModel actingParametersGroup;
    protected ParameterModel nameParameter;
    protected ParameterModel configRefParameter;
    protected ParameterModel actingParameter;
    protected ParameterModel providedParameter;
    protected ParameterModel otherProvidedParameter;
    protected ParameterModel providedParameterFromComplex;
    protected ParameterModel complexActingParameter;
    protected ParameterGroupModel componentParameterGroup;
    protected ParameterGroupModel configParameterGroup;
    protected ParameterModel errorMappingsParameter;
    protected ParameterGroupModel errorMappingsParameterGroup;
    protected ParameterModel parameterRequiredForMetadata;
    @Mock(lenient=true)
    protected DslResolvingContext dslContext;
    @Mock(lenient=true)
    protected ValueProviderModel valueProviderModel;
    @Mock(lenient=true)
    protected ValueProviderModel complexValueProviderModel;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private Set<ExtensionModel> extensions;
    private ElementDeclarer declarer;

    @Before
    public void before() {
        MetadataType stringType = this.TYPE_LOADER.load(String.class);
        this.nameParameter = this.createParameterModel("name", true, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.configRefParameter = this.createParameterModel("config-ref", false, this.TYPE_LOADER.load(ConfigurationProvider.class), null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.singletonList(StereotypeModelBuilder.newStereotype((String)CONFIGURATION_NAME, (String)EXTENSION_NAME).withParent(MuleStereotypes.CONFIG).build()));
        Mockito.when((Object)this.valueProviderModel.getPartOrder()).thenReturn((Object)0);
        Mockito.when((Object)this.valueProviderModel.getProviderName()).thenReturn((Object)VALUE_PROVIDER_NAME);
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)VALUE_PROVIDER_ID);
        Mockito.when((Object)this.valueProviderModel.getActingParameters()).thenReturn(Arrays.asList("actingParameter", "parameterInGroup"));
        ActingParameterModel actingParameterModel = this.createActingParameterModel("actingParameter");
        ActingParameterModel groupActingParameterModel = this.createActingParameterModel("parameterInGroup");
        Mockito.when((Object)this.valueProviderModel.getParameters()).thenReturn(Arrays.asList(actingParameterModel, groupActingParameterModel));
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)false);
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)false);
        Mockito.when((Object)this.complexValueProviderModel.getPartOrder()).thenReturn((Object)0);
        Mockito.when((Object)this.complexValueProviderModel.getProviderName()).thenReturn((Object)COMPLEX_VALUE_PROVIDER_NAME);
        Mockito.when((Object)this.complexValueProviderModel.getProviderId()).thenReturn((Object)COMPLEX_VALUE_PROVIDER_ID);
        Mockito.when((Object)this.complexValueProviderModel.getActingParameters()).thenReturn(Collections.singletonList(COMPLEX_ACTING_PARAMETER_NAME));
        ActingParameterModel complexActingParameterModel = this.createActingParameterModel(COMPLEX_ACTING_PARAMETER_NAME);
        Mockito.when((Object)this.complexValueProviderModel.getParameters()).thenReturn(Collections.singletonList(complexActingParameterModel));
        Mockito.when((Object)this.complexValueProviderModel.requiresConfiguration()).thenReturn((Object)false);
        Mockito.when((Object)this.complexValueProviderModel.requiresConnection()).thenReturn((Object)false);
        this.parameterInGroup = this.createParameterModel("parameterInGroup", false, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.actingParameter = this.createParameterModel("actingParameter", false, stringType, "actingParameter", ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.providedParameter = this.createParameterModel("providedParameter", false, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, this.valueProviderModel, Collections.emptyList());
        this.otherProvidedParameter = this.createParameterModel(OTHER_PROVIDED_PARAMETER_NAME, false, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, this.valueProviderModel, Collections.emptyList());
        this.providedParameterFromComplex = this.createParameterModel(PROVIDED_FROM_COMPLEX_PARAMETER_NAME, false, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, this.complexValueProviderModel, Collections.emptyList());
        this.complexActingParameter = this.createParameterModel(COMPLEX_ACTING_PARAMETER_NAME, false, this.TYPE_LOADER.load(ComplexActingParameter.class), null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.parameterRequiredForMetadata = this.createParameterModel("requiredForMetadata", false, stringType, null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.actingParametersGroup = new ImmutableParameterGroupModel(CUSTOM_PARAMETER_GROUP_NAME, "", Arrays.asList(this.parameterInGroup), Collections.emptyList(), false, null, null, Collections.emptySet());
        this.errorMappingsParameter = this.createParameterModel("errorMappings", false, (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of(this.TYPE_LOADER.load(ErrorMapping.class)).build(), null, ExpressionSupport.NOT_SUPPORTED, ParameterRole.BEHAVIOUR, null, Collections.emptyList());
        this.errorMappingsParameterGroup = new ImmutableParameterGroupModel("Error Mappings", "", Arrays.asList(this.errorMappingsParameter), Collections.emptyList(), false, null, null, Collections.emptySet());
        this.componentParameterGroup = new ImmutableParameterGroupModel("General", "", Arrays.asList(this.configRefParameter, this.actingParameter, this.providedParameter, this.parameterRequiredForMetadata, this.complexActingParameter, this.providedParameterFromComplex), Collections.emptyList(), false, null, null, Collections.emptySet());
        this.configParameterGroup = new ImmutableParameterGroupModel("General", "", Arrays.asList(this.nameParameter, this.actingParameter, this.providedParameter, this.parameterRequiredForMetadata, this.complexActingParameter, this.providedParameterFromComplex), Collections.emptyList(), false, null, null, Collections.emptySet());
        RequiredForMetadataModelProperty requiredForMetadataModelProperty = new RequiredForMetadataModelProperty(Arrays.asList("requiredForMetadata"));
        this.connectionProvider = new ImmutableConnectionProviderModel(CONNECTION_PROVIDER_NAME, "", Arrays.asList(this.componentParameterGroup, this.actingParametersGroup), ConnectionManagementType.NONE, false, Collections.emptySet(), null, MuleStereotypes.CONNECTION, Collections.singleton(requiredForMetadataModelProperty));
        this.operation = this.createOperationModel(OPERATION_NAME, Arrays.asList(this.componentParameterGroup, this.actingParametersGroup, this.errorMappingsParameterGroup));
        this.otherOperation = this.createOperationModel(OTHER_OPERATION_NAME, Arrays.asList(this.componentParameterGroup, this.actingParametersGroup, this.errorMappingsParameterGroup));
        this.source = new ImmutableSourceModel(SOURCE_NAME, "", false, false, Arrays.asList(this.componentParameterGroup, this.actingParametersGroup), Collections.emptyList(), null, null, Optional.empty(), Optional.empty(), Optional.empty(), false, false, false, null, null, Collections.emptySet(), ComponentVisibility.PUBLIC, Collections.emptySet(), Collections.emptySet(), null);
        this.configuration = new ImmutableConfigurationModel(CONFIGURATION_NAME, "", Arrays.asList(this.configParameterGroup, this.actingParametersGroup), Arrays.asList(this.operation, this.otherOperation), Arrays.asList(this.connectionProvider), Arrays.asList(this.source), Collections.emptySet(), null, MuleStereotypes.CONFIG, Collections.singleton(requiredForMetadataModelProperty));
        this.otherConfiguration = new ImmutableConfigurationModel(OTHER_CONFIGURATION_NAME, "", Arrays.asList(this.configParameterGroup, this.actingParametersGroup), Collections.emptyList(), Arrays.asList(this.connectionProvider), Collections.emptyList(), Collections.emptySet(), null, MuleStereotypes.CONFIG, Collections.singleton(requiredForMetadataModelProperty));
        this.mockExtension = this.createExtensionMock();
        Mockito.when((Object)this.dslContext.getExtension((String)ArgumentMatchers.any())).thenReturn(Optional.of(this.mockExtension));
        Mockito.when((Object)this.dslContext.getExtensions()).thenReturn(Collections.singleton(this.mockExtension));
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).build();
        TypeCatalog typeCatalog = DslResolvingContext.getDefault(this.extensions).getTypeCatalog();
        Mockito.when((Object)this.dslContext.getTypeCatalog()).thenReturn((Object)typeCatalog);
        this.declarer = ElementDeclarer.forExtension((String)EXTENSION_NAME);
    }

    private ImmutableParameterModel createParameterModel(String paramName, boolean isComponentId, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, ParameterRole parameterRole, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes) {
        return (ImmutableParameterModel)Mockito.spy((Object)new ImmutableParameterModel(paramName, "", type, false, false, false, isComponentId, expressionSupport, defaultValue, parameterRole, ParameterDslConfiguration.getDefaultInstance(), null, null, valueProviderModel, allowedStereotypes, Collections.emptySet()));
    }

    private ImmutableOperationModel createOperationModel(String operationName, List<ParameterGroupModel> paramGroups) {
        return new ImmutableOperationModel(operationName, "", paramGroups, Collections.emptyList(), null, null, true, ExecutionType.BLOCKING, false, false, false, null, Collections.emptySet(), MuleStereotypes.PROCESSOR, ComponentVisibility.PUBLIC, Collections.emptySet(), Collections.emptySet());
    }

    protected ExtensionModel createExtensionMock() {
        return new ImmutableExtensionModel(EXTENSION_NAME, "", "1.0", "Mulesoft", Category.COMMUNITY, Arrays.asList(this.configuration, this.otherConfiguration), Arrays.asList(this.operation, this.otherOperation), Arrays.asList(this.connectionProvider), Arrays.asList(this.source), Collections.emptyList(), Collections.emptyList(), null, XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix(NAMESPACE).setNamespace(NAMESPACE_URI).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("4.0").build(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    protected ActingParameterModel createActingParameterModel(String parameterName) {
        return this.createActingParameterModel(parameterName, parameterName);
    }

    protected ActingParameterModel createActingParameterModel(String parameterName, String extractionExpression) {
        ActingParameterModel actingParameterModel = (ActingParameterModel)Mockito.mock(ActingParameterModel.class);
        Mockito.when((Object)actingParameterModel.getName()).thenReturn((Object)parameterName);
        Mockito.when((Object)actingParameterModel.getExtractionExpression()).thenReturn((Object)extractionExpression);
        return actingParameterModel;
    }

    protected FieldValueProviderModel createFieldValueProviderModel(String providerName, String providerId, String targetSelector) {
        FieldValueProviderModel fieldValueProviderModel = (FieldValueProviderModel)Mockito.mock(FieldValueProviderModel.class);
        Mockito.when((Object)fieldValueProviderModel.getProviderName()).thenReturn((Object)providerName);
        Mockito.when((Object)fieldValueProviderModel.getProviderId()).thenReturn((Object)providerId);
        Mockito.when((Object)fieldValueProviderModel.requiresConnection()).thenReturn((Object)false);
        Mockito.when((Object)fieldValueProviderModel.requiresConfiguration()).thenReturn((Object)false);
        Mockito.when((Object)fieldValueProviderModel.getTargetSelector()).thenReturn((Object)targetSelector);
        return fieldValueProviderModel;
    }

    protected ConfigurationElementDeclaration declareConfig(ConnectionElementDeclaration connectionDeclaration, String name, String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)((ConfigurationElementDeclarer)this.declarer.newConfiguration(CONFIGURATION_NAME).withRefName(name).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).withConnection(connectionDeclaration).getDeclaration();
    }

    protected ConfigurationElementDeclaration declareOtherConfig(ConnectionElementDeclaration connectionDeclaration, String name, String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)((ConfigurationElementDeclarer)this.declarer.newConfiguration(OTHER_CONFIGURATION_NAME).withRefName(name).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).withConnection(connectionDeclaration).getDeclaration();
    }

    protected ConnectionElementDeclaration declareConnection(String parameterRequiredForMetadata, String actingParameter, String providedParameter, String parameterInGroup) {
        return (ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)this.declarer.newConnection(CONNECTION_PROVIDER_NAME).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("requiredForMetadata", parameterRequiredForMetadata).withParameter("actingParameter", actingParameter).withParameter("providedParameter", providedParameter).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", parameterInGroup).getDeclaration())).getDeclaration();
    }

    public OperationElementDeclaration declareOperation(String operationName) {
        return (OperationElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation(operationName).withConfig(MY_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("actingParameter", "actingParameter").withParameter("providedParameter", "providedParameter").withParameter(COMPLEX_ACTING_PARAMETER_NAME, ComplexActingParameterUtils.declareComplexActingParameter(new ComplexActingParameter(ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getIntParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getStringParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getListParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getMapParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getInnerPojoParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexListParam(), ComplexActingParameterUtils.DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexMapParam()))).withParameter(PROVIDED_FROM_COMPLEX_PARAMETER_NAME, "providedParameter").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", "parameterInGroup").getDeclaration())).getDeclaration();
    }

    protected ArtifactDeclaration getBaseApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)this.declareConfig(this.declareConnection("requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"), MY_CONFIG, "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)this.declarer.newSource(SOURCE_NAME).withConfig(MY_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("actingParameter", "actingParameter").withParameter("providedParameter", "providedParameter").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)CUSTOM_PARAMETER_GROUP_NAME).withParameter("parameterInGroup", "parameterInGroup").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)this.declareOperation(OPERATION_NAME))).withComponent((ComponentElementDeclaration)this.declareOperation(OTHER_OPERATION_NAME))).getDeclaration()).getDeclaration();
    }

    protected ComponentAst getComponentAst(ArtifactAst app, String location) {
        Reference componentAst = new Reference();
        app.recursiveStream().forEach(c -> {
            if (c.getLocation().getLocation().equals(location)) {
                componentAst.set(c);
            }
        });
        return (ComponentAst)componentAst.get();
    }

    protected Optional<ElementDeclaration> getDeclaration(ArtifactDeclaration app, String location) {
        return app.findElement(Location.builderFromStringRepresentation((String)location).build());
    }

    protected ArtifactAst loadApplicationModel(ArtifactDeclaration declaration) throws Exception {
        return ArtifactDeclarationUtils.toArtifactast((ArtifactDeclaration)declaration, this.extensions);
    }

    private String collectLog(ValueProviderCacheId valueProviderCacheId, int level) {
        StringBuilder logId = new StringBuilder();
        if (level == 0) {
            logId.append(System.lineSeparator());
        }
        logId.append(valueProviderCacheId.toString());
        if (!valueProviderCacheId.getParts().isEmpty()) {
            int newLevel = level + 1;
            valueProviderCacheId.getParts().forEach(p -> {
                logId.append(System.lineSeparator());
                IntStream.range(0, newLevel).forEach(i -> logId.append(" "));
                logId.append("+-").append(this.collectLog((ValueProviderCacheId)p, newLevel));
            });
        }
        return logId.toString();
    }

    protected void checkIdsAreEqual(Optional<ValueProviderCacheId> id1, Optional<ValueProviderCacheId> id2) {
        LOGGER.debug("ID1: " + id1.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        LOGGER.debug("ID2: " + id2.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        MatcherAssert.assertThat(id1, (Matcher)Matchers.equalTo(id2));
    }

    protected void checkIdsAreDifferent(Optional<ValueProviderCacheId> id1, Optional<ValueProviderCacheId> id2) {
        LOGGER.debug("ID1: " + id1.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        LOGGER.debug("ID2: " + id2.map(i -> this.collectLog((ValueProviderCacheId)i, 0)).orElse("empty"));
        MatcherAssert.assertThat(id1, (Matcher)IsNot.not((Matcher)Matchers.equalTo(id2)));
    }

    protected static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<org.mule.runtime.api.component.location.Location, ComponentAst> components = new HashMap<org.mule.runtime.api.component.location.Location, ComponentAst>();

        Locator(ArtifactAst app) {
            app.topLevelComponentsStream().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(org.mule.runtime.api.component.location.Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private org.mule.runtime.api.component.location.Location getLocation(ComponentAst component) {
            return org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)component.getLocation().getLocation()).build();
        }

        private void addComponent(ComponentAst component) {
            this.components.put(this.getLocation(component), component);
            component.directChildrenStream().forEach(this::addComponent);
        }
    }
}

