/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.editors;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.config.internal.editors.QNamePropertyEditor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class QNamePropertyEditorTestCase
extends AbstractMuleTestCase {
    @Test
    public void testFullQNameString() {
        QName name = QNamePropertyEditor.convert((String)"qname{e:echo:http://muleumo.org/echo}");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"e", (Object)name.getPrefix());
        Assert.assertEquals((Object)"echo", (Object)name.getLocalPart());
        Assert.assertEquals((Object)"http://muleumo.org/echo", (Object)name.getNamespaceURI());
    }

    @Test
    public void testFullQNameStringWithColonsInNamespace() {
        QName name = QNamePropertyEditor.convert((String)"qname{e:echo:urn:muleumo:echo}");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"e", (Object)name.getPrefix());
        Assert.assertEquals((Object)"echo", (Object)name.getLocalPart());
        Assert.assertEquals((Object)"urn:muleumo:echo", (Object)name.getNamespaceURI());
    }

    @Test
    public void testNameAndNamespace() {
        QName name = QNamePropertyEditor.convert((String)"qname{echo:http://muleumo.org/echo}");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"http://muleumo.org/echo", (Object)name.getNamespaceURI());
        Assert.assertEquals((Object)"echo", (Object)name.getLocalPart());
        Assert.assertEquals((Object)"", (Object)name.getPrefix());
    }

    @Test
    public void testNameOnly() {
        QName name = QNamePropertyEditor.convert((String)"qname{echo}");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"", (Object)name.getNamespaceURI());
        Assert.assertEquals((Object)"echo", (Object)name.getLocalPart());
        Assert.assertEquals((Object)"", (Object)name.getPrefix());
    }

    @Test
    public void testNameOnlyWithoutBraces() {
        QName name = QNamePropertyEditor.convert((String)"echo");
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"", (Object)name.getNamespaceURI());
        Assert.assertEquals((Object)"echo", (Object)name.getLocalPart());
        Assert.assertEquals((Object)"", (Object)name.getPrefix());
    }
}

