/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.lazy;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.lazy.AbstractLazyMuleArtifactContextTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Component life cycle")
public class LazyComponentInitializerAdapterTestCase
extends AbstractLazyMuleArtifactContextTestCase {
    private final AtomicInteger initializations = new AtomicInteger(0);

    @Override
    protected void onProcessorInitialization() {
        this.initializations.incrementAndGet();
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldNotCreateBeansForSameLocationRequest() {
        Location location = Location.builderFromStringRepresentation((String)"myFlow").build();
        this.lazyMuleArtifactContext.initializeComponent(location);
        this.lazyMuleArtifactContext.initializeComponent(location);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldCreateBeansForSameLocationRequestIfDifferentPhaseApplied() {
        Location location = Location.builderFromStringRepresentation((String)"myFlow").build();
        this.lazyMuleArtifactContext.initializeComponent(location, false);
        this.lazyMuleArtifactContext.initializeComponent(location);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)2));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldNotCreateBeansForSameLocationFilterRequest() {
        LazyComponentInitializer.ComponentLocationFilter filter = loc -> loc.getLocation().equals("myFlow");
        this.lazyMuleArtifactContext.initializeComponents(filter);
        this.lazyMuleArtifactContext.initializeComponents(filter);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)1));
    }

    @Test
    @Issue(value="MULE-17400")
    public void shouldCreateBeansForSameLocationFilterRequestIfDifferentPhaseApplied() {
        LazyComponentInitializer.ComponentLocationFilter filter = loc -> loc.getLocation().equals("myFlow");
        this.lazyMuleArtifactContext.initializeComponents(filter, false);
        this.lazyMuleArtifactContext.initializeComponents(filter);
        MatcherAssert.assertThat((Object)this.initializations.get(), (Matcher)Is.is((Object)2));
    }

    @Override
    protected ArtifactDeclaration getArtifactDeclaration() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName("myFlow").getDeclaration()).getDeclaration();
    }
}

