/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ClassLoaderResourceProviderTestCase
extends AbstractMuleTestCase {
    private ClassLoaderResourceProvider resourceProvider;

    @Before
    public void setUp() {
        this.resourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void sameJarResourceGetsLoaded() {
        this.verifyResourceGetsLoadedSuccessfully("META-INF/mule-core.xsd");
    }

    @Test
    public void differentJarResourceGetsLoaded() {
        this.verifyResourceGetsLoadedSuccessfully("javax/inject/Inject.class");
    }

    @Test
    public void absolutePathResourceGetsLoaded() throws IOException {
        Optional<URL> muleModulePropertiesUrl = Collections.list(((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/mule-module.properties")).stream().filter(url -> {
            try {
                return url.toURI().getScheme().equals("file") && !url.toURI().getPath().contains(".jar!");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).findAny();
        File file = FileUtils.toFile((URL)muleModulePropertiesUrl.get());
        this.verifyResourceGetsLoadedSuccessfully(file.getAbsolutePath());
    }

    private void verifyResourceGetsLoadedSuccessfully(String resource) {
        try (InputStream content = this.resourceProvider.getResourceAsStream(resource);){
            Assert.assertThat((Object)content, (Matcher)IsNull.notNullValue());
        }
        catch (IOException e) {
            Assert.fail();
        }
    }
}

