/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.config.internal.factories.MuleConfigurationConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class MuleConfigurationConfiguratorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Rule
    public SystemProperty gracefulShutdownDefaultTimeout = new SystemProperty("mule.gracefulShutdown.defaultTimeout", null);
    private MuleConfigurationConfigurator muleConfigurationConfigurator;

    @Before
    public void setUp() {
        this.muleConfigurationConfigurator = new MuleConfigurationConfigurator();
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        this.muleConfigurationConfigurator.setMuleContext(muleContext);
        this.muleConfigurationConfigurator.setRegistry((Registry)Mockito.mock(Registry.class));
    }

    @Test
    public void shutdownTimeoutConfigured() throws Exception {
        this.muleConfigurationConfigurator.setShutdownTimeout(100L);
        MuleConfiguration configuration = (MuleConfiguration)this.muleConfigurationConfigurator.getObject();
        MatcherAssert.assertThat((Object)configuration.getShutdownTimeout(), (Matcher)Is.is((Object)100L));
    }

    @Test
    public void shutdownTimeoutDefaultByEnvironment() throws Exception {
        System.setProperty("mule.gracefulShutdown.defaultTimeout", "200");
        try {
            MuleConfiguration configuration = (MuleConfiguration)this.muleConfigurationConfigurator.getObject();
            MatcherAssert.assertThat((Object)configuration.getShutdownTimeout(), (Matcher)Is.is((Object)200L));
        }
        finally {
            System.clearProperty("mule.gracefulShutdown.defaultTimeout");
        }
    }

    @Test
    public void shutdownTimeoutDefaultByEnvironmentInvalid() throws Exception {
        System.setProperty("mule.gracefulShutdown.defaultTimeout", "aaa");
        try {
            this.exceptionRule.expect(NumberFormatException.class);
            this.muleConfigurationConfigurator.getObject();
        }
        finally {
            System.clearProperty("mule.gracefulShutdown.defaultTimeout");
        }
    }

    @Test
    public void shutdownTimeoutDefault() throws Exception {
        MuleConfiguration configuration = (MuleConfiguration)this.muleConfigurationConfigurator.getObject();
        MatcherAssert.assertThat((Object)configuration.getShutdownTimeout(), (Matcher)Is.is((Object)5000L));
    }
}

