/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.utils.AppParserConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class DefaultShutdowntimeoutTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public SystemProperty gracefulShutdownDefaultTimeout = new SystemProperty("mule.gracefulShutdown.defaultTimeout", "1234");

    protected Set<ExtensionModel> getExtensionModels() {
        return Collections.singleton(MuleExtensionModelProvider.getExtensionModel());
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new AppParserConfigurationBuilder(new String[]{"./simple.xml"});
    }

    @Test
    @Description(value="Verify that the dsl/extModel do not have a default value that overrides the one from the environment configuration.")
    public void defaultShutdownTimeoutOverride() {
        MatcherAssert.assertThat((Object)muleContext.getConfiguration().getShutdownTimeout(), (Matcher)Is.is((Object)1234L));
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

