/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import com.google.common.collect.ImmutableSet;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.dsl.model.AbstractMetadataCacheIdGeneratorTestCase;
import org.mule.runtime.config.dsl.model.ModelBasedMetadataCacheKeyGeneratorTestCase;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="SDK Tooling Support")
@Story(value="Metadata Cache")
public class ModelBasedTypeMetadataCacheKeyGeneratorTestCase
extends AbstractMetadataCacheIdGeneratorTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelBasedMetadataCacheKeyGeneratorTestCase.class);
    private static final String MY_FLOW = "myFlow";
    private static final String CONFIGLESS_FLOW = "configlessFlow";
    private static final String MY_CONFIG = "myConfig";
    private static final String OPERATION_LOCATION = "myFlow/processors/0";
    public static final String MY_GLOBAL_TEMPLATE = "myGlobalTemplate";
    private static final String MY_OTHER_FLOW = "myOtherFlow";
    private static final String ANOTHER_OPERATION_LOCATION = "myOtherFlow/processors/0";

    @Test
    public void operationsWithSameOutputType() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentOutputTypeResolvers() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithOutputStaticTypeAgainstDynamicType() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentOutputResolversCategory() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.anotherOperation, "anotherCategory", "resolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithSameAttributesType() throws Exception {
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentAttributesTypeResolvers() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithAttributeStaticTypeAgainstDynamicType() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "category", "anotherResolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentAttributesResolversCategory() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.operation, "category", "resolverName");
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.anotherOperation, "anotherCategory", "resolverName");
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsInputHashIdStructure() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(keyParts.toString());
        MatcherAssert.assertThat((Object)keyParts.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)6));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(2)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"category:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(3)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"resolver:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(4)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"Input"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(5)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"metadataKeyValues"));
    }

    @Test
    public void operationsOutputHashIdStructure() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithOutputType((EnrichableModel)this.operation, "category", "outputResolverName");
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MatcherAssert.assertThat((Object)keyParts.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)6));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(2)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"category:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(3)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"resolver:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(4)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"Output"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(5)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"metadataKeyValues"));
    }

    @Test
    public void operationsOutputAttributesHashIdStructure() throws Exception {
        this.mockTypeResolversInformationModelPropertyWithAttributeType((EnrichableModel)this.operation, "category", "outputAttributesResolverName");
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MatcherAssert.assertThat((Object)keyParts.getParts(), (Matcher)IsCollectionWithSize.hasSize((int)6));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(2)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"category:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(3)).getSourceElementName().get()), (Matcher)Matchers.startsWith((String)"resolver:"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(4)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"Attributes"));
        MatcherAssert.assertThat((Object)((String)((MetadataCacheId)keyParts.getParts().get(5)).getSourceElementName().get()), (Matcher)Matchers.equalTo((Object)"metadataKeyValues"));
    }

    @Test
    public void operationsWithSameInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        HashMap<String, String> anotherParameterResolversNames = new HashMap<String, String>();
        anotherParameterResolversNames.put("listName", "listName");
        anotherParameterResolversNames.put("anotherMyCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "category", anotherParameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentInputTypeResolvers() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(keyParts.toString());
        HashMap<String, String> anotherParameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("anotherMyCamelCaseName", "changed");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "category", anotherParameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "anotherMyCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithInputTypeStaticTypeAgainstDynamicType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "anotherMyCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentInputResolversCategory() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.anotherOperation, "anotherCategory", parameterResolversNames);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticOutputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticAttributeTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationsWithDifferentStaticInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.anotherOperation);
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithStaticOutputAndInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentOutputMetadata(this.getBaseApp(), OPERATION_LOCATION);
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentAttributesMetadata(this.getBaseApp(), ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithStaticInputTypes() throws Exception {
        this.removeTypeResolversInformationModelPropertyfromMock((EnrichableModel)this.operation);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void operationWithParametersOfSameInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "listName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.is((Object)otherKeyParts));
    }

    @Test
    public void operationWithParametersOfDifferentInputType() throws Exception {
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        parameterResolversNames.put("myCamelCaseName", "myCamelCaseName");
        this.mockTypeResolversInformationModelPropertyWithInputTypes((EnrichableModel)this.operation, "category", parameterResolversNames);
        MetadataCacheId keyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "listName");
        LOGGER.debug(keyParts.toString());
        MetadataCacheId otherKeyParts = this.getIdForComponentInputMetadata(this.getBaseApp(), OPERATION_LOCATION, "myCamelCaseName");
        LOGGER.debug(otherKeyParts.toString());
        MatcherAssert.assertThat((Object)keyParts, (Matcher)Matchers.not((Object)otherKeyParts));
    }

    @Test
    public void sameComponentsOnDifferentExtensionsGenerateDifferentHash() throws Exception {
        String newExtensionModelName = "newMockedExtension";
        String newNamespace = "new-mockns";
        String newNamespaceUri = "http://www.mulesoft.org/schema/mule/new-mockns";
        String newSchemaLocation = "http://www.mulesoft.org/schema/mule/new-mockns/current/mule-new-mockns.xsd";
        ExtensionModel newExtensionModel = this.createExtension("newMockedExtension", XmlDslModel.builder().setXsdFileName("new-mule-mockns.xsd").setPrefix("new-mockns").setNamespace("http://www.mulesoft.org/schema/mule/new-mockns").setSchemaLocation("http://www.mulesoft.org/schema/mule/new-mockns/current/mule-new-mockns.xsd").setSchemaVersion("4.0").build(), Arrays.asList(this.configuration), Arrays.asList(this.connectionProvider));
        this.extensions = ImmutableSet.builder().add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)this.mockExtension).add((Object)newExtensionModel).build();
        this.dslResolvingContext = DslResolvingContext.getDefault((Set)this.extensions);
        this.dslFactory = DslElementModelFactory.getDefault((DslResolvingContext)this.dslResolvingContext);
        ElementDeclarer newElementDeclarer = ElementDeclarer.forExtension((String)"newMockedExtension");
        String newFlowName = "myNewFlow";
        String newConfigName = "myNewConfig";
        ArtifactDeclaration baseApp = this.getBaseApp();
        ArtifactDeclaration app = (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)baseApp.getGlobalElements().get(0)).withGlobalElement((GlobalElementDeclaration)baseApp.getGlobalElements().get(1)).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)newElementDeclarer.newConfiguration("configuration").withRefName("myNewConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)newElementDeclarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName("myNewFlow").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)newElementDeclarer.newOperation("mockOperation").withConfig("myNewConfig")).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(CONFIGLESS_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)newElementDeclarer.newOperation("mockOperation").withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).getDeclaration();
        String extensionOperationLocation = OPERATION_LOCATION;
        String newExtensionOperationLocation = "myNewFlow/processors/0";
        MetadataCacheId oldHash = this.getIdForComponentOutputMetadata(baseApp, OPERATION_LOCATION);
        MetadataCacheId newHash = this.getIdForComponentOutputMetadata(app, "myNewFlow/processors/0");
        MatcherAssert.assertThat((Object)oldHash, (Matcher)Matchers.is((Matcher)Matchers.not((Object)newHash)));
        String configlessProcessorLocation = "configlessFlow/processors/0";
        oldHash = this.getIdForComponentOutputMetadata(baseApp, "configlessFlow/processors/0");
        newHash = this.getIdForComponentOutputMetadata(app, "configlessFlow/processors/0");
        MatcherAssert.assertThat((Object)oldHash, (Matcher)Matchers.is((Matcher)Matchers.not((Object)newHash)));
    }

    @Test
    public void sameTypesOnDifferentOperationsWithDifferentKeyResolverGeneratesSameHash() throws Exception {
        String category = "category";
        String outputResolverName = "outputResolver";
        HashMap<String, String> parameterResolversNames = new HashMap<String, String>();
        parameterResolversNames.put("listName", "listName");
        String attributesResolverName = "attributesResolver";
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.operation, "category", "outputResolver", "attributesResolver", parameterResolversNames, "operationKeysResolver");
        this.mockTypeResolversInformationModelProperty((EnrichableModel)this.anotherOperation, "category", "outputResolver", "attributesResolver", parameterResolversNames, "anotherOperationKeysResolver");
        ArtifactDeclaration baseApp = this.getBaseApp();
        MetadataCacheId operationOutputMetadataCacheId = this.getIdForComponentOutputMetadata(baseApp, OPERATION_LOCATION);
        LOGGER.debug(operationOutputMetadataCacheId.toString());
        MetadataCacheId operationListInputMetadataCacheId = this.getIdForComponentInputMetadata(baseApp, OPERATION_LOCATION, "listName");
        LOGGER.debug(operationListInputMetadataCacheId.toString());
        MetadataCacheId operationAttributesMetadataCacheId = this.getIdForComponentAttributesMetadata(baseApp, OPERATION_LOCATION);
        LOGGER.debug(operationAttributesMetadataCacheId.toString());
        MetadataCacheId anotherOperationOutputMetadataCacheId = this.getIdForComponentOutputMetadata(baseApp, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationOutputMetadataCacheId.toString());
        MetadataCacheId anotherOperationListInputMetadataCacheId = this.getIdForComponentInputMetadata(baseApp, ANOTHER_OPERATION_LOCATION, "listName");
        LOGGER.debug(anotherOperationListInputMetadataCacheId.toString());
        MetadataCacheId anotherOperationAttributesMetadataCacheId = this.getIdForComponentAttributesMetadata(baseApp, ANOTHER_OPERATION_LOCATION);
        LOGGER.debug(anotherOperationAttributesMetadataCacheId.toString());
        MatcherAssert.assertThat((Object)operationOutputMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationOutputMetadataCacheId));
        MatcherAssert.assertThat((Object)operationListInputMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationListInputMetadataCacheId));
        MatcherAssert.assertThat((Object)operationAttributesMetadataCacheId, (Matcher)Matchers.is((Object)anotherOperationAttributesMetadataCacheId));
    }

    private ArtifactDeclaration getBaseApp() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)this.declarer.newConfiguration("configuration").withRefName(MY_CONFIG).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)this.declarer.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("myCamelCaseName", "#[{field: value}]").withParameter("otherName", "additional").withParameter("listName", (ParameterValue)ElementDeclarer.newListValue().withValue("itemValue").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("mockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey").withParameter("metadataKeyParameter", "keyA"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(CONFIGLESS_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)this.declarer.newOperation("mockOperation").withParameterGroup(g -> g.withParameter("myCamelCaseName", "nonKey"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)ElementDeclarer.forExtension((String)"mule").newConstruct("flow").withRefName(MY_OTHER_FLOW).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)this.declarer.newOperation("anotherMockOperation").withConfig(MY_CONFIG)).withParameterGroup(g -> g.withParameter("anotherMyCamelCaseName", "anotherNonKey").withParameter("metadataKeyParameter", "keyA"))).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)this.declarer.newGlobalParameter("complexType").withRefName(MY_GLOBAL_TEMPLATE).withValue(ParameterObjectValue.builder().withParameter("otherName", "simpleParam").withParameter("myCamelCaseName", "someContent").withParameter("numbers", (ParameterValue)ParameterListValue.builder().withValue("10").withValue("20").build()).build()).getDeclaration()).getDeclaration();
    }
}

