/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model;

import io.qameta.allure.Issue;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ComponentBuildingDefinitionRegistryTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-17484538")
    public void lastRegisteredTakesPrecedence() {
        ComponentBuildingDefinitionRegistry registry = new ComponentBuildingDefinitionRegistry();
        ComponentIdentifier collidingComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"ext:comp");
        ComponentBuildingDefinition definition1 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition1.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        registry.register(definition1);
        ComponentBuildingDefinition definition2 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition2.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        registry.register(definition2);
        MatcherAssert.assertThat((Object)((ComponentBuildingDefinition)registry.getBuildingDefinition(collidingComponentIdentifier).get()), (Matcher)Matchers.sameInstance((Object)definition2));
    }

    @Test
    @Issue(value="W-17484538")
    public void lastRegisteredTakesPrecedenceWithPredicate() {
        ComponentBuildingDefinitionRegistry registry = new ComponentBuildingDefinitionRegistry();
        ComponentIdentifier collidingComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"ext:comp");
        ComponentBuildingDefinition definition1 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition1.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        registry.register(definition1);
        ComponentBuildingDefinition definition2 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition2.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        registry.register(definition2);
        MatcherAssert.assertThat((Object)((ComponentBuildingDefinition)registry.getBuildingDefinition(collidingComponentIdentifier, d -> true).get()), (Matcher)Matchers.sameInstance((Object)definition2));
    }

    @Test
    @Issue(value="W-17484538")
    public void getRegisteredWithPredicate() {
        ComponentBuildingDefinitionRegistry registry = new ComponentBuildingDefinitionRegistry();
        ComponentIdentifier collidingComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"ext:comp");
        ComponentBuildingDefinition definition1 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition1.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        Mockito.when((Object)definition1.getTypeConverter()).thenReturn(Optional.of((TypeConverter)Mockito.mock(TypeConverter.class)));
        registry.register(definition1);
        ComponentBuildingDefinition definition2 = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)definition2.getComponentIdentifier()).thenReturn((Object)collidingComponentIdentifier);
        Mockito.when((Object)definition2.getTypeConverter()).thenReturn(Optional.empty());
        registry.register(definition2);
        MatcherAssert.assertThat((Object)((ComponentBuildingDefinition)registry.getBuildingDefinition(collidingComponentIdentifier, d -> d.getTypeConverter().isPresent()).get()), (Matcher)Matchers.sameInstance((Object)definition1));
    }
}

