/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.processor;

import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.core.internal.processor.LoggerMessageProcessor;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ObjectTypeVisitorTestCase
extends AbstractMuleTestCase {
    private static final String LOGGER_PROCESSOR_FQCN = LoggerMessageProcessor.class.getName();
    @Mock(lenient=true)
    private StringType stringType;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void loadClassLoader() throws ClassNotFoundException {
        Thread.currentThread().getContextClassLoader().loadClass(LOGGER_PROCESSOR_FQCN);
    }

    @Test
    public void typeIsInstanceOfGivenClass() {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().build());
        TypeDefinition typeDefinition = TypeDefinition.fromType(String.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)String.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfGivenClassFromAttribute() {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().withRawParameter("type", LOGGER_PROCESSOR_FQCN).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type");
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)LoggerMessageProcessor.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfCheckedClassFromAttribute() {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().withRawParameter("type", LOGGER_PROCESSOR_FQCN).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(LoggerMessageProcessor.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)LoggerMessageProcessor.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void typeIsInstanceOfClassInheritedFromCheckedClassFromAttribute() {
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().withRawParameter("type", LOGGER_PROCESSOR_FQCN).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(AbstractComponent.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
        Assert.assertTrue((boolean)AbstractComponent.class.isAssignableFrom(visitor.getType()));
    }

    @Test
    public void testFailsIfTypeIsNotOfCheckedClass() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("is not the same nor inherits from");
        ObjectTypeVisitor visitor = new ObjectTypeVisitor(this.baseComponentModelBuilder().withRawParameter("type", ((Object)((Object)this)).getClass().getName()).build());
        TypeDefinition typeDefinition = TypeDefinition.fromConfigurationAttribute((String)"type").checkingThatIsClassOrInheritsFrom(LoggerMessageProcessor.class);
        typeDefinition.visit((TypeDefinitionVisitor)visitor);
    }

    private ComponentAstBuilder baseComponentModelBuilder() {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"type");
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)this.stringType);
        ParameterGroupModel defaultGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)defaultGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)defaultGroup.getName()).thenReturn((Object)"General");
        Mockito.when((Object)defaultGroup.getParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)defaultGroup.getParameter("flat")).thenReturn(Optional.of(parameterModel));
        ParameterizedModel parameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterized.getAllParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        Mockito.when((Object)parameterized.getParameterGroupModels()).thenReturn(Collections.singletonList(defaultGroup));
        return ComponentAstBuilder.builder().withIdentifier(ComponentIdentifier.builder().namespace("ns").name("comp").build()).withParameterizedModel(parameterized).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
    }
}

