/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.config.internal.registry.SpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Feature(value="Registry")
@Story(value="Object Registration")
public class SpringRegistryTestCase
extends AbstractMuleTestCase {
    private ConfigurableApplicationContext appContext;
    private DefaultListableBeanFactory beanFactory;
    private ExecutorService executor;

    @Before
    public void setUp() {
        this.appContext = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        this.beanFactory = new DefaultListableBeanFactory();
        Mockito.when((Object)this.appContext.getBeanFactory()).thenReturn((Object)this.beanFactory);
        this.executor = Executors.newFixedThreadPool(1);
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    @Issue(value="MULE-20042")
    public void unregisterBeanWhoseCreationFails() throws RegistrationException {
        SpringRegistry registry = new SpringRegistry((ApplicationContext)this.appContext, (ApplicationContext)this.appContext, (MuleContext)Mockito.mock(MuleContext.class), (ConfigurationDependencyResolver)Mockito.mock(ConfigurationDependencyResolver.class), (LifecycleInterceptor)Mockito.mock(LifecycleInterceptor.class));
        this.beanFactory.registerBeanDefinition("key", (BeanDefinition)new GenericBeanDefinition());
        Mockito.when((Object)this.appContext.getBean("key")).thenThrow(BeanCreationException.class);
        MatcherAssert.assertThat((Object)registry.unregisterObject("key"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((NoSuchBeanDefinitionException)Assert.assertThrows(NoSuchBeanDefinitionException.class, () -> this.beanFactory.getBeanDefinition("key"))), (Matcher)ThrowableMessageMatcher.hasMessage((String)"No bean named 'key' available"));
        MatcherAssert.assertThat((Object)this.beanFactory.getSingleton("key"), (Matcher)Matchers.nullValue());
    }

    @Test
    @Issue(value="W-14722908")
    public void registryIsReadOnlyWhileStopping() throws LifecycleException {
        LifecycleInterceptor lifecycleInterceptor = (LifecycleInterceptor)Mockito.mock(LifecycleInterceptor.class);
        Mockito.when((Object)lifecycleInterceptor.beforePhaseExecution((LifecyclePhase)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        BeanWithLifeCycle beanWithLifeCycle = new BeanWithLifeCycle(this.executor, "stop");
        SpringRegistry registry = this.buildLifeCycleTesteableSpringRegistry(lifecycleInterceptor, Collections.singletonMap("beanWithLifeCycle", beanWithLifeCycle));
        beanWithLifeCycle.setRegistryUnderTest(registry);
        registry.fireLifecycle("initialise");
        registry.fireLifecycle("start");
        registry.fireLifecycle("stop");
        MatcherAssert.assertThat((Object)beanWithLifeCycle.getRegistrationException().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)beanWithLifeCycle.getRegistrationException().get().getMessage(), (Matcher)Matchers.containsString((String)"Could not add entry with key 'stopObject': Registry has been stopped."));
    }

    @Test
    @Issue(value="W-14722908")
    public void registryIsReadOnlyWhileDisposing() throws MuleException {
        LifecycleInterceptor lifecycleInterceptor = (LifecycleInterceptor)Mockito.mock(LifecycleInterceptor.class);
        Mockito.when((Object)lifecycleInterceptor.beforePhaseExecution((LifecyclePhase)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)true);
        BeanWithLifeCycle beanWithLifeCycle = new BeanWithLifeCycle(this.executor, "dispose");
        SpringRegistry registry = this.buildLifeCycleTesteableSpringRegistry(lifecycleInterceptor, Collections.singletonMap("beanWithLifeCycle", beanWithLifeCycle));
        beanWithLifeCycle.setRegistryUnderTest(registry);
        registry.fireLifecycle("initialise");
        registry.fireLifecycle("start");
        registry.fireLifecycle("stop");
        registry.fireLifecycle("dispose");
        MatcherAssert.assertThat((Object)beanWithLifeCycle.getRegistrationException().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)beanWithLifeCycle.getRegistrationException().get().getMessage(), (Matcher)Matchers.containsString((String)"Could not add entry with key 'disposeObject': Registry has been stopped."));
    }

    private SpringRegistry buildLifeCycleTesteableSpringRegistry(LifecycleInterceptor lifecycleInterceptor, final Map<String, ?> singletonBeansToRegister) {
        singletonBeansToRegister.forEach((key, value) -> {
            Mockito.when((Object)this.appContext.getBean(key)).thenReturn(value);
            Mockito.when((Object)this.appContext.isSingleton(key)).thenReturn((Object)true);
            this.beanFactory.registerBeanDefinition(key, (BeanDefinition)new GenericBeanDefinition());
        });
        return new SpringRegistry((ApplicationContext)this.appContext, (ApplicationContext)this.appContext, null, (ConfigurationDependencyResolver)Mockito.mock(ConfigurationDependencyResolver.class), lifecycleInterceptor){

            <T> Map<String, T> lookupEntriesForLifecycle(Class<T> type) {
                return singletonBeansToRegister;
            }

            protected <T> Map<String, T> lookupEntriesForLifecycleIncludingAncestors(Class<T> type) {
                return singletonBeansToRegister;
            }
        };
    }

    public static class BeanWithLifeCycle
    implements Stoppable,
    Disposable {
        private SpringRegistry registryUnderTest;
        private final ExecutorService registrationExecutor;
        private final String phaseUnderTest;
        private volatile RegistrationException registrationException;

        public BeanWithLifeCycle(ExecutorService registrationExecutor, String phaseUnderTest) {
            this.registrationExecutor = registrationExecutor;
            this.phaseUnderTest = phaseUnderTest;
        }

        public void stop() {
            if (this.phaseUnderTest.equals("stop")) {
                try {
                    this.addObjectToRegistry("stopObject", new Object());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void dispose() {
            if (this.phaseUnderTest.equals("dispose")) {
                try {
                    this.addObjectToRegistry("disposeObject", new Object());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void addObjectToRegistry(String registryKey, Object objectToAdd) throws ExecutionException, InterruptedException {
            this.registrationExecutor.submit(() -> {
                try {
                    this.registryUnderTest.registerObject(registryKey, objectToAdd);
                }
                catch (RegistrationException e) {
                    this.registrationException = e;
                    throw new RuntimeException(e);
                }
            }).get();
        }

        public void setRegistryUnderTest(SpringRegistry registryUnderTest) {
            this.registryUnderTest = registryUnderTest;
        }

        public Optional<RegistrationException> getRegistrationException() {
            return Optional.ofNullable(this.registrationException);
        }
    }
}

