/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.api;

import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ComponentBuildingDefinitionTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectException = ExpectedException.none();
    private ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withIdentifier("test").withNamespace("namespace");

    @Test
    public void simpleTypeWithTypeConverter() {
        this.baseDefinition.withTypeDefinition(TypeDefinition.fromType(Integer.class)).withTypeConverter(this.getFakeTypeConverter()).build();
    }

    @Test
    public void typeFromConfigAndTypeConverter() {
        this.expectException.expectMessage(Is.is((Object)"Type converter cannot be used with a type definition from a configuration attribute."));
        this.baseDefinition.withTypeDefinition(TypeDefinition.fromConfigurationAttribute((String)"class")).withTypeConverter(this.getFakeTypeConverter()).build();
    }

    @Test
    public void noSimpleTypeWithTypeConverter() {
        this.expectException.expectMessage(Is.is((Object)String.format("Type converter can only be used with simple types. You can't use it with %s", Object.class.getName())));
        this.baseDefinition.withTypeDefinition(TypeDefinition.fromType(Object.class)).withTypeConverter(this.getFakeTypeConverter()).build();
    }

    @Test
    public void keyTypeConverterAndNoMapType() {
        this.expectException.expectMessage(Is.is((Object)"key type converter can only be used with objects of type Map"));
        this.baseDefinition.withTypeDefinition(TypeDefinition.fromType(Object.class)).withKeyTypeConverter(this.getFakeTypeConverter()).build();
    }

    private TypeConverter getFakeTypeConverter() {
        return o -> null;
    }
}

