/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mockito;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.internal.ArtifactAstConfigurationBuilder;
import org.mule.runtime.config.internal.bean.TestCustomServiceDependingOnMuleConfiguration;
import org.mule.runtime.config.internal.model.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.transformer.simple.ObjectToInputStream;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.module.artifact.activation.api.ast.ArtifactAstUtils;
import org.mule.runtime.module.artifact.activation.api.ast.AstXmlParserSupplier;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.MockExtensionManagerConfigurationBuilder;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.IsEmptyOptional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties story")
public class MuleConfigurationConfiguratorTestCase
extends AbstractMuleTestCase {
    private static final String CUSTOM_SERVICE_DEPENDING_ON_MULE_CONFIGURATION = "TestCustomServiceDependingOnMuleConfiguration";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleConfigurationConfiguratorTestCase.class);
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private final TimeSupplier timeSupplier = (TimeSupplier)Mockito.mock(TimeSupplier.class);
    private MuleContextWithRegistry muleContext;

    @After
    public void after() {
        if (this.muleContext != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.muleContext, (Logger)LOGGER);
        }
    }

    @Test
    public void whenNotConfiguredThenHasSameDefaults() throws MuleException {
        DefaultMuleConfiguration config = (DefaultMuleConfiguration)this.getMuleContext().getRegistry().lookupObject("_muleConfiguration");
        MatcherAssert.assertThat((Object)config, (Matcher)Is.is((Object)this.getMuleContext().getConfiguration()));
        this.assertEqualsToMuleConfigurationInjectedInCustomService((MuleConfiguration)config);
        DefaultMuleConfiguration defaultConfig = new DefaultMuleConfiguration();
        MatcherAssert.assertThat((Object)config.getDefaultResponseTimeout(), (Matcher)Is.is((Object)defaultConfig.getDefaultResponseTimeout()));
        MatcherAssert.assertThat((Object)config.getWorkingDirectory(), (Matcher)Is.is((Object)defaultConfig.getWorkingDirectory()));
        MatcherAssert.assertThat((Object)config.getMuleHomeDirectory(), (Matcher)Is.is((Object)defaultConfig.getMuleHomeDirectory()));
        MatcherAssert.assertThat((Object)config.getDefaultTransactionTimeout(), (Matcher)Is.is((Object)defaultConfig.getDefaultTransactionTimeout()));
        MatcherAssert.assertThat((Object)config.isClientMode(), (Matcher)Is.is((Object)defaultConfig.isClientMode()));
        MatcherAssert.assertThat((Object)config.getDefaultEncoding(), (Matcher)Is.is((Object)defaultConfig.getDefaultEncoding()));
        MatcherAssert.assertThat((Object)config.getDomainId(), (Matcher)Is.is((Object)defaultConfig.getDomainId()));
        MatcherAssert.assertThat((Object)config.getSystemModelType(), (Matcher)Is.is((Object)defaultConfig.getSystemModelType()));
        MatcherAssert.assertThat((Object)config.isAutoWrapMessageAwareTransform(), (Matcher)Is.is((Object)defaultConfig.isAutoWrapMessageAwareTransform()));
        MatcherAssert.assertThat((Object)config.isCacheMessageAsBytes(), (Matcher)Is.is((Object)defaultConfig.isCacheMessageAsBytes()));
        MatcherAssert.assertThat((Object)config.isEnableStreaming(), (Matcher)Is.is((Object)defaultConfig.isEnableStreaming()));
        MatcherAssert.assertThat((Object)config.isValidateExpressions(), (Matcher)Is.is((Object)defaultConfig.isValidateExpressions()));
        MatcherAssert.assertThat((Object)config.isLazyInit(), (Matcher)Is.is((Object)defaultConfig.isLazyInit()));
        MatcherAssert.assertThat((Object)config.getDefaultQueueTimeout(), (Matcher)Is.is((Object)defaultConfig.getDefaultQueueTimeout()));
        MatcherAssert.assertThat((Object)config.getShutdownTimeout(), (Matcher)Is.is((Object)defaultConfig.getShutdownTimeout()));
        MatcherAssert.assertThat((Object)config.getMaxQueueTransactionFilesSizeInMegabytes(), (Matcher)Is.is((Object)defaultConfig.getMaxQueueTransactionFilesSizeInMegabytes()));
        MatcherAssert.assertThat((Object)config.isContainerMode(), (Matcher)Is.is((Object)defaultConfig.isContainerMode()));
        MatcherAssert.assertThat((Object)config.isStandalone(), (Matcher)Is.is((Object)defaultConfig.isStandalone()));
        MatcherAssert.assertThat((Object)config.getDefaultErrorHandlerName(), (Matcher)Is.is((Object)defaultConfig.getDefaultErrorHandlerName()));
        MatcherAssert.assertThat((Object)config.isDisableTimeouts(), (Matcher)Is.is((Object)defaultConfig.isDisableTimeouts()));
        MatcherAssert.assertThat((Object)config.getDefaultObjectSerializer(), (Matcher)Is.is((Object)defaultConfig.getDefaultObjectSerializer()));
        MatcherAssert.assertThat((Object)config.getDefaultProcessingStrategyFactory(), (Matcher)Is.is((Object)defaultConfig.getDefaultProcessingStrategyFactory()));
        this.assertDynamicConfigExpirationEquals(config.getDynamicConfigExpiration(), defaultConfig.getDynamicConfigExpiration());
        MatcherAssert.assertThat((Object)config.isInheritIterableRepeatability(), (Matcher)Is.is((Object)defaultConfig.isInheritIterableRepeatability()));
        MatcherAssert.assertThat((Object)config.getMinMuleVersion(), (Matcher)Is.is((Object)defaultConfig.getMinMuleVersion()));
        MatcherAssert.assertThat((Object)config.getDefaultCorrelationIdGenerator(), (Matcher)Is.is((Object)defaultConfig.getDefaultCorrelationIdGenerator()));
        MatcherAssert.assertThat((Object)config.getArtifactCoordinates(), (Matcher)Is.is((Object)defaultConfig.getArtifactCoordinates()));
        MatcherAssert.assertThat((Object)config.isFlowTrace(), (Matcher)Is.is((Object)defaultConfig.isFlowTrace()));
        MatcherAssert.assertThat((Object)config.getExtendedProperties(), (Matcher)Is.is((Object)defaultConfig.getExtendedProperties()));
        MatcherAssert.assertThat((Object)config.getExtensions(), (Matcher)Is.is((Object)defaultConfig.getExtensions()));
    }

    @Test
    public void whenConfiguredThroughSystemPropertiesThenHasExpectedValues() throws MuleException {
        System.setProperty("mule.encoding", "UTF-16");
        System.setProperty("mule.systemModelType", "direct");
        System.setProperty("mule.workingDirectory", "some-working-dir");
        System.setProperty("mule.clientMode", "true");
        System.setProperty("mule.serverId", "MY_SERVER");
        System.setProperty("mule.domainId", "MY_DOMAIN");
        System.setProperty("mule.message.cacheBytes", "false");
        System.setProperty("mule.streaming.enable", "false");
        System.setProperty("mule.transform.autoWrap", "false");
        System.setProperty("mule.validate.expressions", "false");
        System.setProperty("mule.timeout.disable", "true");
        try {
            this.whenNotConfiguredThenHasSameDefaults();
            MatcherAssert.assertThat((Object)this.getMuleContext().getConfiguration().getId(), (Matcher)Is.is((Object)new DefaultMuleConfiguration().getId()));
        }
        finally {
            System.clearProperty("mule.encoding");
            System.clearProperty("mule.systemModelType");
            System.clearProperty("mule.workingDirectory");
            System.clearProperty("mule.clientMode");
            System.clearProperty("mule.serverId");
            System.clearProperty("mule.domainId");
            System.clearProperty("mule.message.cacheBytes");
            System.clearProperty("mule.streaming.enable");
            System.clearProperty("mule.transform.autoWrap");
            System.clearProperty("mule.validate.expressions");
            System.clearProperty("mule.timeout.disable");
        }
    }

    @Test
    public void whenConfiguredFromConfigFileThenHasExpectedValues() throws MuleException {
        this.initMuleContext("withGlobalConfig.xml");
        DefaultMuleConfiguration config = (DefaultMuleConfiguration)this.getMuleContext().getRegistry().lookupObject("_muleConfiguration");
        MatcherAssert.assertThat((Object)config, (Matcher)Is.is((Object)this.getMuleContext().getConfiguration()));
        this.assertEqualsToMuleConfigurationInjectedInCustomService((MuleConfiguration)config);
        MatcherAssert.assertThat((Object)config.getDefaultErrorHandlerName(), (Matcher)Is.is((Object)"errorHandler"));
        MatcherAssert.assertThat((Object)config.getDefaultResponseTimeout(), (Matcher)Is.is((Object)5000));
        MatcherAssert.assertThat((Object)config.getMaxQueueTransactionFilesSizeInMegabytes(), (Matcher)Is.is((Object)100));
        MatcherAssert.assertThat((Object)config.getDefaultTransactionTimeout(), (Matcher)Is.is((Object)20000));
        MatcherAssert.assertThat((Object)config.getShutdownTimeout(), (Matcher)Is.is((Object)2000L));
        MatcherAssert.assertThat((Object)config.getDefaultObjectSerializer(), (Matcher)Is.isA(TestSerializationProtocol.class));
        MatcherAssert.assertThat((Object)config.isInheritIterableRepeatability(), (Matcher)Is.is((Object)true));
        DynamicConfigExpiration dynamicConfigExpiration = config.getDynamicConfigExpiration();
        MatcherAssert.assertThat((Object)dynamicConfigExpiration.getFrequency().getTime(), (Matcher)Is.is((Object)7L));
        MatcherAssert.assertThat((Object)((Object)dynamicConfigExpiration.getFrequency().getUnit()), (Matcher)Is.is((Object)((Object)TimeUnit.DAYS)));
        MatcherAssert.assertThat((Object)dynamicConfigExpiration.getExpirationPolicy().getMaxIdleTime(), (Matcher)Is.is((Object)40L));
        MatcherAssert.assertThat((Object)((Object)dynamicConfigExpiration.getExpirationPolicy().getTimeUnit()), (Matcher)Is.is((Object)((Object)TimeUnit.HOURS)));
        MatcherAssert.assertThat((Object)config.getDefaultCorrelationIdGenerator(), (Matcher)Matchers.not((Matcher)Is.is((Matcher)IsEmptyOptional.empty())));
    }

    @Test
    public void whenMultipleConfigsInFileThenFails() {
        ConfigurationException e = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> this.initMuleContext("withMultipleGlobalConfig.xml"));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"The configuration element 'configuration' can only appear once")));
    }

    @Test
    public void whenBeanFromConfigFileDependsOnMuleConfigurationThenItSeesTheCorrectValues() throws MuleException {
        this.initMuleContext("withGlobalConfig.xml");
        MatcherAssert.assertThat((Object)this.runFlow("mainFlow"), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Is.is((Object)"errorHandler"))));
    }

    @Test
    @Issue(value="MULE-19006")
    public void configuratorExpirationPolicyUsesManagedTimeSupplier() throws Exception {
        MuleConfiguration configuration = (MuleConfiguration)this.getMuleContext().getRegistry().lookupObject("_muleConfiguration");
        ExpirationPolicy policy = configuration.getDynamicConfigExpiration().getExpirationPolicy();
        MatcherAssert.assertThat((Object)policy, (Matcher)Matchers.instanceOf(ImmutableExpirationPolicy.class));
        configuration.getDynamicConfigExpiration().getExpirationPolicy().isExpired(0L, TimeUnit.DAYS);
        ((TimeSupplier)Mockito.verify((Object)this.timeSupplier)).getAsLong();
    }

    @Test
    @Issue(value="MULE-20031")
    public void muleContextInjectedIntoTransformers() throws Exception {
        ObjectToInputStream o2isTransformer = (ObjectToInputStream)this.getMuleContext().getRegistry().lookupObject(ObjectToInputStream.class);
        MatcherAssert.assertThat((Object)o2isTransformer.doTransform(Collections.singletonMap("key", "value"), StandardCharsets.UTF_8), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    private void assertEqualsToMuleConfigurationInjectedInCustomService(MuleConfiguration actualConfig) throws MuleException {
        TestCustomServiceDependingOnMuleConfiguration testService = (TestCustomServiceDependingOnMuleConfiguration)this.getMuleContext().getRegistry().lookupObject(CUSTOM_SERVICE_DEPENDING_ON_MULE_CONFIGURATION);
        MatcherAssert.assertThat((Object)actualConfig, (Matcher)Is.is((Object)testService.getMuleConfiguration()));
    }

    private void assertDynamicConfigExpirationEquals(DynamicConfigExpiration actual, DynamicConfigExpiration expected) {
        MatcherAssert.assertThat((Object)actual.getFrequency().getTime(), (Matcher)Is.is((Object)expected.getFrequency().getTime()));
        MatcherAssert.assertThat((Object)((Object)actual.getFrequency().getUnit()), (Matcher)Is.is((Object)((Object)expected.getFrequency().getUnit())));
        MatcherAssert.assertThat((Object)actual.getExpirationPolicy().getMaxIdleTime(), (Matcher)Is.is((Object)expected.getExpirationPolicy().getMaxIdleTime()));
        MatcherAssert.assertThat((Object)((Object)actual.getExpirationPolicy().getTimeUnit()), (Matcher)Is.is((Object)((Object)expected.getExpirationPolicy().getTimeUnit())));
    }

    private CoreEvent runFlow(String flowName) throws MuleException {
        FlowConstruct flow = this.getMuleContext().getRegistry().lookupFlowConstruct(flowName);
        EventContext eventContext = EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)DefaultComponentLocation.from((String)flow.getName()));
        CoreEvent event = CoreEvent.builder((EventContext)eventContext).message(Message.builder().nullValue().build()).build();
        return ((Flow)flow).process(event);
    }

    private MuleContextWithRegistry getMuleContext() throws MuleException {
        if (this.muleContext == null) {
            this.initMuleContext();
        }
        return this.muleContext;
    }

    private void initMuleContext() throws MuleException {
        this.initMuleContext(null);
    }

    private void initMuleContext(String configPath) throws MuleException {
        String[] stringArray;
        if (configPath != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = configPath;
        } else {
            stringArray = new String[]{};
        }
        String[] configFiles = stringArray;
        this.muleContext = (MuleContextWithRegistry)new DefaultMuleContextFactory().createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                muleContext.getCustomizationService().interceptDefaultServiceImpl("_muleTimeSupplier", si -> si.overrideServiceImpl((Object)MuleConfigurationConfiguratorTestCase.this.timeSupplier));
                muleContext.getCustomizationService().registerCustomServiceClass(MuleConfigurationConfiguratorTestCase.CUSTOM_SERVICE_DEPENDING_ON_MULE_CONFIGURATION, TestCustomServiceDependingOnMuleConfiguration.class);
            }
        }, new MockExtensionManagerConfigurationBuilder(Collections.singleton(MuleExtensionModelProvider.getExtensionModel())), new AppParserConfigurationBuilder(configFiles)});
        this.muleContext.start();
        this.muleContext.getRegistry().lookupByType(Calendar.class);
    }

    public static class TestSerializationProtocol
    implements ObjectSerializer {
        public SerializationProtocol getInternalProtocol() {
            return null;
        }

        public SerializationProtocol getExternalProtocol() {
            return null;
        }
    }

    private static class AppParserConfigurationBuilder
    extends AbstractConfigurationBuilder
    implements AstXmlParserSupplier {
        private final String[] configFiles;

        private AppParserConfigurationBuilder(String[] configFiles) {
            this.configFiles = configFiles;
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
            ArtifactAst artifactAst = this.configFiles.length == 0 ? MuleAstUtils.emptyArtifact() : ArtifactAstUtils.parseAndBuildAppExtensionModel((String)muleContext.getConfiguration().getId(), (String[])this.configFiles, (AstXmlParserSupplier)this, (Set)muleContext.getExtensionManager().getExtensions(), (boolean)false, (ClassLoader)muleContext.getExecutionClassLoader(), (MuleConfiguration)muleContext.getConfiguration(), null);
            new ArtifactAstConfigurationBuilder(artifactAst, Collections.emptyMap(), ArtifactType.APP, false, false, new DefaultComponentBuildingDefinitionRegistryFactory().create(artifactAst.dependencies(), arg_0 -> ((ArtifactAst)artifactAst).dependenciesDsl(arg_0))).configure(muleContext);
        }

        public AstXmlParser getParser(Set<ExtensionModel> extensions, boolean disableValidations) {
            return AstXmlParser.builder().withArtifactType(org.mule.runtime.ast.api.ArtifactType.APPLICATION).withExtensionModels(extensions).build();
        }
    }
}

