/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import com.google.common.collect.ImmutableList;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class PropertiesResolverConfigurationPropertiesResolverTestCase
extends AbstractMuleTestCase {
    private static final String FIXED_VALUE = "fixedValue";
    private static final String CHILD_RESOLVER_DESCRIPTION = "child resolver";
    private static final String PARENT_RESOLVER_DESCRIPTION = "parent resolver";
    private DefaultConfigurationPropertiesResolver resolver;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void createResolver() {
        DefaultConfigurationPropertiesResolver parentResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new ConfigurationPropertiesProvider(){
            private List<ConfigurationProperty> attributes = ImmutableList.builder().add((Object)new DefaultConfigurationProperty((Object)this, "parent-key1", (Object)"parent-value1")).add((Object)new DefaultConfigurationProperty((Object)this, "parent-key2", (Object)"parent-value2")).add((Object)new DefaultConfigurationProperty((Object)this, "parent-complex-key1", (Object)"parent-complex-${parent-key1}")).add((Object)new DefaultConfigurationProperty((Object)this, "parent-complex-key2", (Object)"${parent-key1}-${parent-complex-key3}")).add((Object)new DefaultConfigurationProperty((Object)this, "parent-complex-key3", (Object)"${parent-key2}")).add((Object)new DefaultConfigurationProperty((Object)this, "parent-key-referencing-child", (Object)"${child-key1}")).build();

            public Optional<? extends ConfigurationProperty> provide(String configurationAttributeKey) {
                return this.attributes.stream().filter(cf -> cf.getKey().equals(configurationAttributeKey)).findFirst();
            }

            public String getDescription() {
                return PropertiesResolverConfigurationPropertiesResolverTestCase.PARENT_RESOLVER_DESCRIPTION;
            }
        });
        this.resolver = new DefaultConfigurationPropertiesResolver(Optional.of(parentResolver), new ConfigurationPropertiesProvider(){
            private List<ConfigurationProperty> attributes = ImmutableList.builder().add((Object)new DefaultConfigurationProperty((Object)this, "child-key1", (Object)"child-value1")).add((Object)new DefaultConfigurationProperty((Object)this, "child-key2", (Object)"child-value2")).add((Object)new DefaultConfigurationProperty((Object)this, "child-complex-key1", (Object)"${child-key1}-${parent-complex-key1}")).add((Object)new DefaultConfigurationProperty((Object)this, "child-complex-key2", (Object)"${child-key1}-${parent-complex-key2}-${child-key2}")).add((Object)new DefaultConfigurationProperty((Object)this, "unresolved-nested-key", (Object)"${child-key1}-${child-key3}")).add((Object)new DefaultConfigurationProperty((Object)this, "invalid-key1", (Object)"${nonExistentKey}")).build();

            public Optional<? extends ConfigurationProperty> provide(String configurationAttributeKey) {
                return this.attributes.stream().filter(cf -> cf.getKey().equals(configurationAttributeKey)).findFirst();
            }

            public String getDescription() {
                return PropertiesResolverConfigurationPropertiesResolverTestCase.CHILD_RESOLVER_DESCRIPTION;
            }
        });
    }

    @Test
    public void resolveNoPlaceholder() {
        Assert.assertThat((Object)this.resolver.resolveValue(FIXED_VALUE), (Matcher)Is.is((Object)FIXED_VALUE));
    }

    @Test
    public void nullValueReturnsNull() {
        Assert.assertThat((Object)this.resolver.resolveValue(null), (Matcher)IsNull.nullValue());
    }

    @Test
    public void resolveKeyInParent() {
        Assert.assertThat((Object)this.resolver.resolveValue("${parent-key1}"), (Matcher)Is.is((Object)"parent-value1"));
    }

    @Test
    public void resolveKeyInChild() {
        Assert.assertThat((Object)this.resolver.resolveValue("${child-key1}"), (Matcher)Is.is((Object)"child-value1"));
    }

    @Test
    public void resolveParentComplexKey() {
        Assert.assertThat((Object)this.resolver.resolveValue("${parent-complex-key1}"), (Matcher)Is.is((Object)"parent-complex-parent-value1"));
    }

    @Test
    public void resolveChildComplexKey() {
        Assert.assertThat((Object)this.resolver.resolveValue("${child-complex-key1}"), (Matcher)Is.is((Object)"child-value1-parent-complex-parent-value1"));
    }

    @Test
    public void resolveKeyWithServeralLevelsOfIndirection() {
        Assert.assertThat((Object)this.resolver.resolveValue("${child-complex-key2}"), (Matcher)Is.is((Object)"child-value1-parent-value1-parent-value2-child-value2"));
    }

    @Test
    public void parentKeyCannotReferenceChildKey() {
        this.expectedException.expectMessage(Is.is((Object)"Couldn't find configuration property value for key ${parent-key-referencing-child}"));
        this.resolver.resolveValue("${parent-key-referencing-child}");
    }

    @Test
    public void resolveInvalidKey() {
        this.expectedException.expectMessage(Is.is((Object)"Couldn't find configuration property value for key ${nonExistentKey}"));
        this.resolver.resolveValue("${invalid-key1}");
    }

    @Test
    public void unresolvedNestedKey() {
        this.expectedException.expectMessage(Is.is((Object)"Couldn't find configuration property value for key ${child-key3}"));
        this.resolver.resolveValue("${unresolved-nested-key}");
    }

    @Test
    public void resolveWithEscapedPrefix() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\${child-complex-key2}"), (Matcher)Is.is((Object)"Hello ${child-complex-key2}"));
    }

    @Test
    public void resolveWithEscapedPrefixNotClosed() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\${child-complex-key2"), (Matcher)Is.is((Object)"Hello ${child-complex-key2"));
    }

    @Test
    public void resolveWithEscapedPrefixAndNotEscaped() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\${${child-complex-key2}"), (Matcher)Is.is((Object)"Hello ${child-value1-parent-value1-parent-value2-child-value2"));
    }

    @Test
    public void resolveWithDoubleEscape() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\\\${child-key1}"), (Matcher)Is.is((Object)"Hello \\child-value1"));
    }

    @Test
    public void resolveWithDoubleEscapeWithoutPropertyResolution() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\\\zaraza"), (Matcher)Is.is((Object)"Hello \\\\zaraza"));
    }

    @Test
    public void resolveWithDoubleEscapeWithoutEscapingPropertyResolution() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\\\zaraza ${child-key1}"), (Matcher)Is.is((Object)"Hello \\\\zaraza child-value1"));
    }

    @Test
    public void escapedAndNotEscaped() {
        Assert.assertThat((Object)this.resolver.resolveValue("Hello \\${child-key1} = ${child-key1}"), (Matcher)Is.is((Object)"Hello ${child-key1} = child-value1"));
    }

    @Test
    public void escapedAndNotEscapedInBeginning() {
        Assert.assertThat((Object)this.resolver.resolveValue("\\${child-key1} = ${child-key1}"), (Matcher)Is.is((Object)"${child-key1} = child-value1"));
    }

    @Test
    public void notEscapedInBeginning() {
        Assert.assertThat((Object)this.resolver.resolveValue("\\\\${child-key1} = ${child-key1}"), (Matcher)Is.is((Object)"\\child-value1 = child-value1"));
    }
}

