/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidatorBuilder;
import org.mule.runtime.ast.internal.validation.DefaultValidatorBuilder;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@Issue(value="W-10808757")
@Story(value="Application Deployment")
public class MuleArtifactContextTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext;
    private final ClassLoader executionClassloader = (ClassLoader)Mockito.mock(ClassLoader.class);
    private final ClassLoader parentClassloader = (ClassLoader)Mockito.mock(ClassLoader.class);
    private final DefaultListableBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(null);
    private ArtifactAstValidatorBuilder astValidatorBuilder;

    @Before
    public void before() throws MuleException {
        this.astValidatorBuilder = (ArtifactAstValidatorBuilder)Mockito.spy((Object)new DefaultValidatorBuilder());
        Mockito.mockStatic(MuleAstUtils.class);
        Mockito.when((Object)MuleAstUtils.validatorBuilder()).thenReturn((Object)this.astValidatorBuilder);
        Mockito.when((Object)MuleAstUtils.emptyArtifact()).thenCallRealMethod();
        this.mockMuleContext = MuleContextUtils.mockContextWithServices();
        this.mockMuleContext.getInjector().inject((Object)this);
        Mockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)this.executionClassloader);
        Mockito.when((Object)this.executionClassloader.getParent()).thenReturn((Object)this.parentClassloader);
    }

    @Test
    public void testValidationWithFFEnabled() {
        this.createMuleArtifactContextStub(this.beanFactory, this.mockFF(true));
        ((ArtifactAstValidatorBuilder)Mockito.verify((Object)this.astValidatorBuilder, (VerificationMode)Mockito.times((int)1))).withArtifactRegionClassLoader(this.parentClassloader);
    }

    @Test
    public void testValidationWithFFDisabled() {
        this.createMuleArtifactContextStub(this.beanFactory, this.mockFF(false));
        ((ArtifactAstValidatorBuilder)Mockito.verify((Object)this.astValidatorBuilder, (VerificationMode)Mockito.times((int)1))).withArtifactRegionClassLoader(this.executionClassloader);
    }

    private FeatureFlaggingService mockFF(boolean flag) {
        FeatureFlaggingService featureFlaggingService = (FeatureFlaggingService)Mockito.mock(FeatureFlaggingService.class);
        Mockito.when((Object)featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.VALIDATE_APPLICATION_MODEL_WITH_REGION_CLASSLOADER)).thenReturn((Object)flag);
        return featureFlaggingService;
    }

    private MuleArtifactContext createMuleArtifactContextStub(final DefaultListableBeanFactory mockedBeanFactory, FeatureFlaggingService featureFlaggingService) {
        MuleArtifactContext muleArtifactContext = new MuleArtifactContext(this.mockMuleContext, MuleAstUtils.emptyArtifact(), Optional.empty(), new BaseConfigurationComponentLocator(), new ContributedErrorTypeRepository(), new ContributedErrorTypeLocator(), Collections.emptyMap(), false, ArtifactType.APP, new ComponentBuildingDefinitionRegistry(), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), featureFlaggingService, (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)){

            protected DefaultListableBeanFactory createBeanFactory() {
                return mockedBeanFactory;
            }

            protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            }

            protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void registerListeners() {
            }

            protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
            }

            protected void finishRefresh() {
            }
        };
        muleArtifactContext.refresh();
        return muleArtifactContext;
    }
}

