/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CheckAnnotatedTestCase
extends AbstractMuleTestCase {
    private Document schema;
    private Element top;
    private Set<String> annotated = new HashSet<String>();
    private static final String annotatedType = "annotatedType";
    private static final String annotatedMixedContentType = "annotatedMixedContentType";
    private Set<String> allowedExceptions;

    public CheckAnnotatedTestCase() {
        this.annotated.add(annotatedType);
        this.annotated.add(annotatedMixedContentType);
        this.allowedExceptions = new HashSet<String>();
        this.allowedExceptions.add("abstractModelType");
    }

    @Test
    public void testElementTypes() throws Exception {
        this.schema = this.createDOM(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/mule-core-common.xsd"));
        this.top = this.schema.getDocumentElement();
        Element muleRootElements = this.findElement(this.top, "group", "muleRootElements");
        Assert.assertNotNull((Object)muleRootElements);
        Set<Element> muleChildren = this.collectElementChildren(muleRootElements);
        for (Element elm : muleChildren) {
            this.checkElementTypeIsAnnotated(elm);
        }
    }

    private void checkElementTypeIsAnnotated(Element elm) {
        Element type = this.getType(elm);
        if (type != null) {
            this.checkTypeIsAnnotated(type);
        }
    }

    private void checkTypeIsAnnotated(Element type) {
        String typeName = type.getAttribute("name");
        if (this.annotated.contains(typeName) || this.allowedExceptions.contains(typeName)) {
            return;
        }
        Element complexContent = this.findChild(type, "complexContent");
        Element extension = this.findChild(complexContent, "extension");
        String base = extension.getAttribute("base");
        Assert.assertFalse((boolean)base.equals(""));
        this.checkTypeIsAnnotated(this.findElement(this.top, "complexType", base));
        this.annotated.add(typeName);
    }

    private Element getType(Element elm) {
        if (!elm.getAttribute("type").equals("")) {
            return this.findElement(this.top, "complexType", elm.getAttribute("type"));
        }
        return this.findChild(elm, "complexType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDOM(InputStream input) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(input);
            return document;
        }
        finally {
            IOUtils.closeQuietly((Closeable)input);
        }
    }

    private Element findElement(Element parent, String type, String name) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !type.equals(node.getLocalName()) || !((Element)node).getAttribute("name").equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private Element findElement(Element elm) {
        if (!elm.getAttribute("name").equals("")) {
            return elm;
        }
        return this.findElement(this.top, elm.getLocalName(), elm.getAttribute("ref"));
    }

    private Set<Element> collectElementChildren(Element parent) {
        HashSet<Element> children = new HashSet<Element>();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element elm = (Element)node;
            if ("element".equals(node.getLocalName())) {
                children.add(this.findElement(elm));
                continue;
            }
            if (!"sequence".equals(node.getLocalName()) && !"choice".equals(node.getLocalName()) && !"group".equals(node.getLocalName())) continue;
            Set<Element> elms = this.collectElementChildren(elm);
            for (Element e : elms) {
                children.add(this.findElement(e));
            }
        }
        return children;
    }

    private Element findChild(Element parent, String localName) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        Assert.fail((String)("Cannot find child " + localName + " for " + parent.getAttribute("name")));
        return null;
    }
}

