/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.resolvers;

import com.google.common.collect.Sets;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class ConfigurationDependencyResolverTestCase {
    private ConfigurationDependencyResolver configurationDependencyResolver;
    private ArtifactAstDependencyGraph graph;

    @Before
    public void setUp() throws Exception {
        this.graph = (ArtifactAstDependencyGraph)Mockito.mock(ArtifactAstDependencyGraph.class);
        this.configurationDependencyResolver = new ConfigurationDependencyResolver(this.graph);
    }

    @Test
    @Description(value="A set of two components will be returned when there are two required components")
    public void getRequiredComponentsWithIdTestCase() {
        HashSet components = Sets.newHashSet((Object[])new ComponentAst[]{this.createComponentWithId("A"), this.createComponentWithId("B")});
        Mockito.when((Object)this.graph.getRequiredComponents((String)ArgumentMatchers.any())).thenReturn((Object)components);
        Collection result = this.configurationDependencyResolver.getDirectComponentDependencies("component");
        MatcherAssert.assertThat((Object)result, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
    }

    @Test
    @Description(value="A set of three components will be returned when there are 5 required components, only 3 have id")
    public void getRequiredComponentsWithoutIdTestCase() {
        HashSet components = Sets.newHashSet((Object[])new ComponentAst[]{this.createComponentWithId("A"), this.createComponentWithId("B"), this.createComponentWithId("C"), this.createComponentWithoutId("D"), this.createComponentWithoutId("E")});
        Mockito.when((Object)this.graph.getRequiredComponents((String)ArgumentMatchers.any())).thenReturn((Object)components);
        Collection result = this.configurationDependencyResolver.getDirectComponentDependencies("component");
        MatcherAssert.assertThat((Object)result, (Matcher)IsIterableWithSize.iterableWithSize((int)3));
    }

    private ComponentAst createComponentWithId(String componentName) {
        ComponentAst component = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)component.getComponentId()).thenReturn(Optional.of(componentName));
        return component;
    }

    private ComponentAst createComponentWithoutId(String componentName) {
        ComponentAst component = (ComponentAst)Mockito.mock(ComponentAst.class);
        return component;
    }
}

