/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.model.internal.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.properties.api.ResourceProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.IsEqualIgnoringLineBreaks;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class FileConfigurationPropertiesProviderTestCase
extends AbstractMuleTestCase {
    private ConfigurationPropertiesResolver resolver;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void createResolver() {
        ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(Thread.currentThread().getContextClassLoader());
        this.resolver = new ConfigurationPropertiesHierarchyBuilder().withPropertiesFile((ResourceProvider)externalResourceProvider).build();
    }

    @Test
    public void fileIsResolved() {
        Assert.assertThat((Object)((String)this.resolver.resolveValue("${file::dummy.xml}")), (Matcher)Is.is((Matcher)IsEqualIgnoringLineBreaks.equalToIgnoringLineBreaks((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo/>\n")));
    }

    @Test
    public void fileDoesNotExist() {
        this.expectedException.expectMessage(Is.is((Object)"Couldn't find configuration property value for key ${file::non-existing-file}"));
        this.resolver.resolveValue("${file::non-existing-file}");
    }
}

