/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.config.internal.BeanWrapper;
import org.mule.runtime.core.api.MuleContext;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class BeanWrapperTestCase {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void twoDifferentObjectsComparisonTest() {
        Object object1 = new Object();
        Object object2 = new Object();
        BeanWrapper first = new BeanWrapper("firstObject", object1);
        BeanWrapper second = new BeanWrapper("secondObject", object2);
        MatcherAssert.assertThat((Object)first.equals((Object)second), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void sameObjectInWrapperComparisonTest() {
        Object object1 = new Object();
        BeanWrapper first = new BeanWrapper("firstObject", object1);
        MatcherAssert.assertThat((Object)first.equals(object1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sameProxyComparisonTest() {
        Object fProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MuleContext.class}, (InvocationHandler)new MyInvocationHandler(new Object()));
        MatcherAssert.assertThat((Object)fProxy.equals(fProxy), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void sameProxyInWrapperComparisonTest() {
        Object fProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MuleContext.class}, (InvocationHandler)new MyInvocationHandler(new Object()));
        BeanWrapper wrapper = new BeanWrapper("proxy", fProxy);
        MatcherAssert.assertThat((Object)wrapper.equals((Object)wrapper), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void sameProxyInTwoDifferentWrappersComparisonTest() {
        Object fProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MuleContext.class}, (InvocationHandler)new MyInvocationHandler(new Object()));
        BeanWrapper wrapper1 = new BeanWrapper("proxy1", fProxy);
        BeanWrapper wrapper2 = new BeanWrapper("proxy2", fProxy);
        MatcherAssert.assertThat((Object)wrapper1.equals((Object)wrapper2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)wrapper2.equals((Object)wrapper1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void objectInProxyAndWrapperComparisonTest() {
        Object obj = new Object();
        Object fProxy1 = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MuleContext.class}, (InvocationHandler)new MyInvocationHandler(obj));
        Object fProxy2 = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MuleContext.class}, (InvocationHandler)new MyInvocationHandler(obj));
        BeanWrapper wrapper1 = new BeanWrapper("proxy1", fProxy1);
        BeanWrapper wrapper2 = new BeanWrapper("proxy2", fProxy2);
        MatcherAssert.assertThat((Object)wrapper1.equals((Object)wrapper2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)wrapper2.equals((Object)wrapper1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nullInWrapperTest() {
        this.exceptionRule.expect(NullPointerException.class);
        this.exceptionRule.expectMessage("bean must not be null");
        new BeanWrapper("null", null);
    }

    @Test
    public void twoDifferentObjectsInWrapperTest() {
        Object object1 = new Object();
        Object object2 = new Object();
        BeanWrapper first = new BeanWrapper("firstObject", object1);
        BeanWrapper second = new BeanWrapper("secondObject", object2);
        MatcherAssert.assertThat((Object)first.equals((Object)second), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void differentObjectsInWrapperTest() {
        Object object1 = new Object();
        Object object2 = new Object();
        BeanWrapper first = new BeanWrapper("firstObject", object1);
        MatcherAssert.assertThat((Object)first.equals(object2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getBasicInfoTest() {
        Object object1 = new Object();
        Object object2 = new Object();
        BeanWrapper first = new BeanWrapper("firstObject", object1);
        BeanWrapper second = new BeanWrapper("secondObject", object2);
        MatcherAssert.assertThat((Object)first.getName().equals("firstObject"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)(first.hashCode() == second.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)false));
    }

    private static class MyInvocationHandler
    implements InvocationHandler {
        Object wrappedObject;

        public MyInvocationHandler(Object obj) {
            this.wrappedObject = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return this.wrappedObject.equals(args[0]);
            }
            if (method.getName().equals("hashCode")) {
                return this.wrappedObject.hashCode();
            }
            return null;
        }
    }
}

