/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.resolvers;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.config.internal.registry.AbstractSpringRegistry;
import org.mule.runtime.config.internal.resolvers.DeclaredDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.InjectedDependenciesProvider;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DeclaredDependencyResolverTestCase {
    private DeclaredDependencyResolver declaredDependencyResolver;
    private AbstractSpringRegistry springRegistry;
    private InjectedDependenciesProvider object;

    @Before
    public void setUp() throws Exception {
        this.springRegistry = (AbstractSpringRegistry)Mockito.mock(AbstractSpringRegistry.class);
        this.object = (InjectedDependenciesProvider)Mockito.mock(InjectedDependenciesProvider.class);
        this.declaredDependencyResolver = new DeclaredDependencyResolver(this.springRegistry);
    }

    @Test
    @Description(value="check if getDeclaredDirectDependencies properly interacts with InjectedDependencyProvider")
    public void getDeclaredDirectDependenciesInteractionTest() {
        this.declaredDependencyResolver.getDeclaredDependencies((Object)this.object);
        ((InjectedDependenciesProvider)Mockito.verify((Object)this.object, (VerificationMode)Mockito.atLeastOnce())).getInjectedDependencies();
    }

    @Test
    @Description(value="check if the method returns declared dependencies correctly")
    public void getDeclaredDirectDependenciesTest() {
        Class<MuleContext> type = MuleContext.class;
        String beanName = "muleContext";
        Object ob = new Object();
        Mockito.when((Object)this.object.getInjectedDependencies()).thenReturn(Arrays.asList(Either.left(type)));
        Mockito.when((Object)this.springRegistry.get(beanName)).thenReturn(ob);
        String[] beanNames = new String[]{beanName};
        Mockito.when((Object)this.springRegistry.getBeanNamesForType(type)).thenReturn((Object)beanNames);
        Assert.assertThat((Object)this.declaredDependencyResolver.getDeclaredDependencies((Object)this.object).size(), (Matcher)Matchers.is((Object)1));
    }
}

