/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProviderConfiguration;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.internal.context.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanDefinitionFactoryTestCase
extends AbstractMuleTestCase {
    private static Map<?, ?> descriptorsCache;
    private ComponentBuildingDefinition<?> buildingDefinition;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private ComponentAst componentAst;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Field descriptorsCacheField = PropertyUtilsBean.class.getDeclaredField("descriptorsCache");
        descriptorsCacheField.setAccessible(true);
        PropertyUtilsBean propertyUtilsBean = BeanUtilsBean.getInstance().getPropertyUtils();
        descriptorsCache = (Map)descriptorsCacheField.get(propertyUtilsBean);
    }

    @Before
    public void setUp() {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)"mock:component");
        SetterAttributeDefinition setterDef = new SetterAttributeDefinition("attr", AttributeDefinition.Builder.fromUndefinedSimpleAttributes().build());
        this.buildingDefinition = (ComponentBuildingDefinition)Mockito.mock(ComponentBuildingDefinition.class);
        Mockito.when((Object)this.buildingDefinition.getComponentIdentifier()).thenReturn((Object)componentIdentifier);
        Mockito.when((Object)this.buildingDefinition.getSetterParameterDefinitions()).thenReturn(Collections.singletonList(setterDef));
        Mockito.when((Object)this.buildingDefinition.getTypeDefinition()).thenReturn((Object)TypeDefinition.fromType(TestObjectProvider.class));
        SpringComponentModel springComponentModel = new SpringComponentModel();
        springComponentModel.setType(TestObjectProvider.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)this.componentAst.getIdentifier()).thenReturn((Object)componentIdentifier);
        Mockito.when((Object)this.componentAst.getMetadata()).thenReturn((Object)ComponentMetadataAst.EMPTY_METADATA);
        Mockito.when((Object)this.componentAst.getLocation()).thenReturn((Object)location);
        springComponentModel.setComponent(this.componentAst);
        this.beanDefinitionRegistry = (BeanDefinitionRegistry)Mockito.mock(BeanDefinitionRegistry.class);
    }

    @Test
    @Issue(value="W-18350339")
    public void eagerObjectCreationPopulatesACacheThatIsClearedOnFactoryClose() {
        ComponentBuildingDefinitionRegistry definitionRegistry = new ComponentBuildingDefinitionRegistry();
        definitionRegistry.register(this.buildingDefinition);
        BeanDefinitionFactory factory = new BeanDefinitionFactory("test-artifact", definitionRegistry, false, false);
        factory.resolveComponent(new HashMap(), Collections.emptyList(), this.componentAst, this.beanDefinitionRegistry, new SpringConfigurationComponentLocator());
        MatcherAssert.assertThat((String)"descriptorsCache should have the test entry", descriptorsCache, (Matcher)Matchers.hasKey(TestObjectProvider.class));
        factory.close();
        MatcherAssert.assertThat((String)"descriptorsCache should be empty", descriptorsCache, (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }

    public static class TestObjectProvider
    implements ConfigurableObjectProvider {
        public Optional<Object> getObject(String s) {
            return Optional.empty();
        }

        public Optional<Object> getObjectByType(Class<?> type) {
            return Optional.empty();
        }

        public <T> Map<String, T> getObjectsByType(Class<T> type) {
            return Collections.emptyMap();
        }

        public boolean containsObject(String name) {
            return false;
        }

        public Optional<Boolean> isObjectSingleton(String name) {
            return Optional.of(false);
        }

        public ComponentLocation getLocation() {
            return null;
        }

        public Map<QName, Object> getAnnotations() {
            return Collections.emptyMap();
        }

        public Object getAnnotation(QName name) {
            return null;
        }

        public void setAnnotations(Map<QName, Object> annotations) {
        }

        public Location getRootContainerLocation() {
            return null;
        }

        public void configure(ObjectProviderConfiguration objectProviderConfiguration) {
        }
    }
}

