/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.dsl.spring;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.InputStream;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.privileged.dsl.spring.SmartFactoryBeanInterceptor;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.mule.runtime.dsl.api.component.ObjectTypeProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.springframework.beans.factory.SmartFactoryBean;

@Issue(value="W-10672687")
public class ObjectFactoryClassRepositoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();

    @Test
    public void testSetters() throws Exception {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        SmartFactoryBeanInterceptor byteBuddyClass = (SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        SmartFactoryBean bbAsSmf = (SmartFactoryBean)byteBuddyClass;
        byteBuddyClass.setIsSingleton(Boolean.valueOf(true));
        byteBuddyClass.setIsPrototype(Boolean.valueOf(true));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> true));
        Assert.assertThat((Object)bbAsSmf.isSingleton(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)bbAsSmf.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)bbAsSmf.isPrototype(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)bbAsSmf.isEagerInit(), (Matcher)Is.is((Object)true));
        byteBuddyClass.setIsSingleton(Boolean.valueOf(false));
        byteBuddyClass.setIsPrototype(Boolean.valueOf(false));
        byteBuddyClass.setIsEagerInit((Supplier)new LazyValue(() -> false));
        Assert.assertThat((Object)bbAsSmf.isSingleton(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)bbAsSmf.isPrototype(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)bbAsSmf.isEagerInit(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)bbAsSmf.getObject(), (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(FakeObject.class)));
    }

    @Test
    @Issue(value="W-12362157")
    public void getObjectTypeWithoutInitializingTheFields() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        SmartFactoryBeanInterceptor byteBuddyClass = (SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        SmartFactoryBean bbAsSmf = (SmartFactoryBean)byteBuddyClass;
        Assert.assertThat((Object)bbAsSmf.getObjectType(), (Matcher)Is.is(String.class));
    }

    @Test
    @Issue(value="W-12362157")
    public void testSameClassWithDifferentObjectTypeCreateDifferentDynamicClasses() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        SmartFactoryBeanInterceptor byteBuddyClass = (SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        SmartFactoryBean bbAsSmf = (SmartFactoryBean)byteBuddyClass;
        SmartFactoryBeanInterceptor otherByteBuddyClass = (SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(FakeObjectConnectionProviderObjectFactory.class, Integer.class).newInstance();
        SmartFactoryBean ohterBbAsSmf = (SmartFactoryBean)otherByteBuddyClass;
        Assert.assertThat(byteBuddyClass.getClass(), (Matcher)Is.is((Matcher)IsNot.not(otherByteBuddyClass.getClass())));
        Assert.assertThat((Object)bbAsSmf.getObjectType(), (Matcher)Is.is(String.class));
        Assert.assertThat((Object)ohterBbAsSmf.getObjectType(), (Matcher)Is.is(Integer.class));
        Assert.assertThat((Object)byteBuddyClass.getClass().getSuperclass().getName(), (Matcher)Is.is((Object)otherByteBuddyClass.getClass().getSuperclass().getName()));
    }

    @Test
    public void testGetObjectTypeReturnsSuperIfImplementsObjectTypeProvider() throws InstantiationException, IllegalAccessException {
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        SmartFactoryBeanInterceptor byteBuddyClass = (SmartFactoryBeanInterceptor)objectFactoryClassRepository.getObjectFactoryClass(OtherFakeObjectConnectionProviderObjectFactory.class, String.class).newInstance();
        SmartFactoryBean bbAsSmf = (SmartFactoryBean)byteBuddyClass;
        Assert.assertThat((Object)bbAsSmf.getObjectType(), (Matcher)Is.is(Long.class));
    }

    @Test
    @Issue(value="W-14288844")
    @Description(value="Test a scenario where an extension classloader has it's own Spring jars. The classes generated by bytebuddy must implement the Spring interface from the container, not from the extension.")
    public void springInChildClassLoader() throws Exception {
        ClassLoader springFactoryClassLoader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.startsWith("org.springframework.beans.factory.") || name.startsWith(ObjectFactoryClassRepositoryTestCase.class.getPackage().getName() + ".")) {
                    Class<?> alreadyLoaded = super.loadClass(name);
                    if (alreadyLoaded.getClassLoader() == this) {
                        return alreadyLoaded;
                    }
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getResourceAsStream(name.replaceAll("\\.", "/") + ".class"));
                        return this.defineClass(name, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name);
            }

            public String toString() {
                return "springFactoryClassLoader";
            }
        };
        ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();
        Class byteBuddyClass = objectFactoryClassRepository.getObjectFactoryClass(springFactoryClassLoader.loadClass(FakeObjectConnectionProviderObjectFactory.class.getName()), FakeObject.class);
        Assert.assertThat((String)byteBuddyClass.getInterfaces()[1].getClassLoader().toString(), byteBuddyClass.newInstance(), (Matcher)CoreMatchers.instanceOf(SmartFactoryBean.class));
    }

    public static class FakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory {
        public Object doGetObject() {
            return new FakeObject();
        }
    }

    public static class FakeObject
    extends AbstractComponent {
    }

    public static class OtherFakeObjectConnectionProviderObjectFactory
    extends AbstractComponentFactory
    implements ObjectTypeProvider {
        public Object doGetObject() {
            return new FakeObject();
        }

        public Class<?> getObjectType() {
            return Long.class;
        }
    }
}

