/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.spring.security;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.client.MuleClient;
import org.mule.runtime.core.api.context.notification.SecurityNotification;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.tck.junit4.rule.DynamicPort;

public class SecureHttpPollingFunctionalTestCase
extends MuleArtifactFunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String[] getConfigFiles() {
        return new String[]{"secure-http-polling-server-flow.xml", "secure-http-polling-client-flow.xml"};
    }

    @Test
    public void testPollingHttpConnectorSentCredentials() throws Exception {
        final Latch latch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new SecurityNotificationListener<SecurityNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(SecurityNotification notification) {
                latch.countDown();
            }
        });
        MuleClient client = muleContext.getClient();
        Message result = (Message)((Optional)client.request("test://toclient", 5000L).getRight()).get();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo"));
        result = (Message)((Optional)client.request("test://toclient2", 1000L).getRight()).get();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)result.getAttributes().getValue(), (Matcher)CoreMatchers.instanceOf(HttpResponseAttributes.class));
        Assert.assertThat((Object)((HttpResponseAttributes)result.getAttributes().getValue()).getStatusCode(), (Matcher)CoreMatchers.is((Object)401));
        Assert.assertThat((Object)latch.await(1000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
    }
}

