/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.metadata;

import com.google.common.base.Throwables;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.MetadataCacheManager;
import org.mule.runtime.module.extension.api.tooling.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataMediator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.internal.artifact.ExecutorExceptionWrapper;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataExecutor;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyDeclarationResolver;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataKeysExecutor
extends MetadataExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataKeysExecutor.class);
    private static final FailureCode INVALID_PARAMETER_VALUE = new FailureCode("INVALID_PARAMETER_VALUE");

    public MetadataKeysExecutor(ConnectionManager connectionManager, ReflectionCache reflectionCache, ExpressionManager expressionManager, ArtifactHelper artifactHelper, MetadataCacheIdGenerator<ElementDeclaration> metadataCacheIdGenerator, MetadataCacheManager metadataCacheManager) {
        super(connectionManager, reflectionCache, expressionManager, artifactHelper, metadataCacheIdGenerator, metadataCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataResult<MetadataKeysContainer> resolveMetadataKeys(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve metadata keys STARTED for component: {}", (Object)componentModel.getName());
            }
            Optional<ConfigurationInstance> optionalConfigurationInstance = this.getConfigurationInstance(componentModel, componentElementDeclaration);
            MetadataResult metadataKey = new MetadataKeyDeclarationResolver(componentModel, componentElementDeclaration, this.expressionManager).resolvePartialKey();
            ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)this.artifactHelper.getExtensionModel((ElementDeclaration)componentElementDeclaration));
            DefaultMetadataMediator metadataMediator = new DefaultMetadataMediator(componentModel, this.reflectionCache);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invoking connector's metadata key resolver for component: {}", (Object)componentModel.getName());
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(extensionClassLoader);
            try {
                MetadataResult metadataResult = this.runWithMetadataContext(componentElementDeclaration, optionalConfigurationInstance, extensionClassLoader, arg_0 -> MetadataKeysExecutor.lambda$resolveMetadataKeys$0((MetadataMediator)metadataMediator, (MetadataKey)metadataKey, arg_0));
                currentThread.setContextClassLoader(currentClassLoader);
                return metadataResult;
            }
            catch (Throwable throwable) {
                try {
                    currentThread.setContextClassLoader(currentClassLoader);
                    throw throwable;
                }
                catch (MetadataResolvingException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(String.format("Resolve metadata keys has FAILED with code: %s for component: %s", e.getFailure(), componentModel.getName()), (Throwable)e);
                    }
                    metadataKey = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(e.getFailure()).onKeys()});
                    return metadataKey;
                }
                catch (ExpressionNotSupportedException e) {
                    metadataKey = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).withFailureCode(INVALID_PARAMETER_VALUE).onKeys()});
                    return metadataKey;
                }
                catch (ExecutorExceptionWrapper e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof MetadataResolvingException) {
                        MetadataResolvingException metadataResolvingException = (MetadataResolvingException)cause;
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn(String.format("Resolve metadata keys has FAILED with code: %s for component: %s", metadataResolvingException.getFailure(), componentModel.getName()), cause);
                        }
                        MetadataResult metadataResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(metadataResolvingException.getFailure()).onKeys()});
                        return metadataResult;
                    }
                    Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
                    throw new MuleRuntimeException(cause);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e, MuleRuntimeException.class);
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve metadata keys FINISHED for component: {}", (Object)componentModel.getName());
            }
        }
    }

    @Override
    protected boolean resolverRequiresConfiguration(Optional<TypeResolversInformationModelProperty> typeResolversInformationModelProperty, ComponentModel componentModel) {
        return this.artifactHelper.hasParameterOfType(componentModel, MuleStereotypes.CONFIG);
    }

    private static /* synthetic */ MetadataResult lambda$resolveMetadataKeys$0(MetadataMediator metadataMediator, MetadataKey metadataKey, MetadataContext metadataContext) {
        return metadataMediator.getMetadataKeys(metadataContext, metadataKey);
    }
}

