/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.deployment.processor;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.serialization.api.ElementDeclarationJsonSerializer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.deployment.internal.processor.AbstractAstConfigurationProcessor;
import org.mule.runtime.module.deployment.internal.processor.SerializedAstArtifactConfigurationProcessor;
import org.mule.runtime.module.tooling.internal.dsl.ArtifactDeclarationUtils;

public class SerializedArtifactDeclarationArtifactConfigurationProcessor
extends AbstractAstConfigurationProcessor {
    private ArtifactConfigurationProcessor delegate = SerializedAstArtifactConfigurationProcessor.serializedAstWithFallbackArtifactConfigurationProcessor();

    public ArtifactContext createArtifactContext(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        if (Stream.of(artifactContextConfiguration.getConfigResources()).noneMatch("serialized-artifact-declaration.decl"::equals)) {
            return this.delegate.createArtifactContext(artifactContextConfiguration);
        }
        return super.createArtifactContext(artifactContextConfiguration);
    }

    protected ArtifactAst obtainArtifactAst(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        return this.createApplicationModel(artifactContextConfiguration.getMuleContext(), artifactContextConfiguration.getConfigResources(), artifactContextConfiguration.getArtifactProperties(), artifactContextConfiguration.getArtifactType(), artifactContextConfiguration.getParentArtifactContext().map(ArtifactContext::getArtifactAst).orElse(MuleAstUtils.emptyArtifact()), artifactContextConfiguration.isDisableXmlValidations(), artifactContextConfiguration.getExpressionLanguageMetadataService());
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    private ArtifactAst createApplicationModel(MuleContext muleContext, String[] artifactConfigResources, Map<String, String> artifactProperties, ArtifactType artifactType, ArtifactAst parentArtifactAst, boolean disableXmlValidations, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws ConfigurationException {
        Set<ExtensionModel> extensions = this.getExtensions(muleContext.getExtensionManager());
        try {
            String serializedDeclaration = IOUtils.toString((InputStream)new ConfigResource("serialized-artifact-declaration.decl").getInputStream(), (Charset)StandardCharsets.UTF_8);
            ArtifactDeclaration deserializedArtifactDeclaration = (ArtifactDeclaration)ElementDeclarationJsonSerializer.getDefault((boolean)true).deserialize(serializedDeclaration, ArtifactDeclaration.class);
            return ArtifactDeclarationUtils.toArtifactast(deserializedArtifactDeclaration, extensions);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }
}

