/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.license.api.LicenseValidatorProvider;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;
import org.mule.runtime.module.tooling.internal.AbstractArtifactAgnosticService;
import org.mule.runtime.module.tooling.internal.AbstractArtifactAgnosticServiceBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Tooling support in the Runtime")
@Story(value="Service builder")
@Issue(value="W-13057814")
public abstract class AbstractArtifactAgnosticServiceBuilderTestCase
extends AbstractMuleTestCase {
    private final DefaultApplicationFactory applicationFactory = (DefaultApplicationFactory)Mockito.spy((Object)new DefaultApplicationFactory((ApplicationClassLoaderBuilderFactory)Mockito.mock(ApplicationClassLoaderBuilderFactory.class), DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory(), (DomainRepository)Mockito.mock(DomainRepository.class), (ServiceRepository)Mockito.mock(ServiceRepository.class), (ExtensionModelLoaderRepository)Mockito.mock(ExtensionModelLoaderRepository.class), (ClassLoaderRepository)Mockito.mock(ClassLoaderRepository.class), (PolicyTemplateClassLoaderBuilderFactory)Mockito.mock(PolicyTemplateClassLoaderBuilderFactory.class), (PluginDependenciesResolver)Mockito.mock(PluginDependenciesResolver.class), LicenseValidatorProvider.discoverLicenseValidator((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), (MemoryManagementService)Mockito.mock(MemoryManagementService.class), (ArtifactConfigurationProcessor)Mockito.mock(ArtifactConfigurationProcessor.class)));

    @Test
    public void applicationDescriptorCorrectlyCreated() throws Exception {
        AtomicReference applicationDescriptor = new AtomicReference();
        ((DefaultApplicationFactory)Mockito.doAnswer(i -> {
            applicationDescriptor.set((ApplicationDescriptor)i.getArgument(0));
            return Mockito.mock(Application.class);
        }).when((Object)this.applicationFactory)).createArtifact((ApplicationDescriptor)ArgumentMatchers.any());
        ArtifactAgnosticServiceBuilder builder = this.getArtifactAgnosticServiceBuilder(this.applicationFactory);
        ArtifactDeclaration artifactDeclaration = new ArtifactDeclaration();
        builder.setArtifactDeclaration(artifactDeclaration);
        String testKey = "test key";
        String testValue = "test value";
        builder.setArtifactProperties(Collections.singletonMap("test key", "test value"));
        AbstractArtifactAgnosticService session = (AbstractArtifactAgnosticService)builder.build();
        try {
            session.getStartedApplication();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)((ApplicationDescriptor)applicationDescriptor.get()).getAppProperties(), (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat((Object)((ApplicationDescriptor)applicationDescriptor.get()).getAppProperties(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"test key"), (Matcher)Matchers.is((Object)"test value")));
    }

    @Test
    @Issue(value="W-14398600")
    public void addSharedLibraryDependency() {
        AbstractArtifactAgnosticServiceBuilder builder = (AbstractArtifactAgnosticServiceBuilder)this.getArtifactAgnosticServiceBuilder(this.applicationFactory);
        MavenModelBuilder model = (MavenModelBuilder)Mockito.mock(MavenModelBuilder.class);
        builder.setModel(model);
        builder.addDependency("org.mule.test", "test-artifact", "0.0.1", null, "jar");
        builder.addDependency("org.mule.test", "test-not-plugin", "0.0.1", "notAPlugin", "jar");
        builder.addDependency("org.mule.test", "test-mule-plugin", "0.0.1", "mule-plugin", "jar");
        ((MavenModelBuilder)Mockito.verify((Object)model, (VerificationMode)Mockito.times((int)3))).addDependency((BundleDependency)ArgumentMatchers.any());
        ((MavenModelBuilder)Mockito.verify((Object)model, (VerificationMode)Mockito.times((int)2))).addSharedLibraryDependency((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((MavenModelBuilder)Mockito.verify((Object)model)).addSharedLibraryDependency("org.mule.test", "test-artifact");
        ((MavenModelBuilder)Mockito.verify((Object)model)).addSharedLibraryDependency("org.mule.test", "test-not-plugin");
        ((MavenModelBuilder)Mockito.verify((Object)model, (VerificationMode)Mockito.never())).addSharedLibraryDependency(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"test-mule-plugin"));
    }

    protected abstract ArtifactAgnosticServiceBuilder getArtifactAgnosticServiceBuilder(DefaultApplicationFactory var1);
}

