/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.dsl.model;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.module.tooling.internal.dsl.model.ComplexActingParameter;
import org.mule.runtime.module.tooling.internal.dsl.model.DeclarationUtils;
import org.mule.runtime.module.tooling.internal.dsl.model.InnerPojo;
import org.mule.tck.util.func.CheckedConsumer;

public class ComplexActingParameterUtils {
    static final ComplexActingParameter DEFAULT_COMPLEX_ACTING_PARAMETER;

    private ComplexActingParameterUtils() {
    }

    static ParameterValue declareComplexActingParameter(ComplexActingParameter complexActingParameter) {
        int intParam = complexActingParameter.getIntParam();
        String stringParam = complexActingParameter.getStringParam();
        List<String> listParam = complexActingParameter.getListParam();
        Map<String, String> mapParam = complexActingParameter.getMapParam();
        InnerPojo innerPojo = complexActingParameter.getInnerPojoParam();
        List<InnerPojo> complexList = complexActingParameter.getComplexListParam();
        Map<String, InnerPojo> complexMap = complexActingParameter.getComplexMapParam();
        ParameterListValue.Builder listValueBuilder = ParameterListValue.builder();
        listParam.forEach(arg_0 -> ((ParameterListValue.Builder)listValueBuilder).withValue(arg_0));
        ParameterListValue.Builder complexListBuilder = ParameterListValue.builder();
        complexList.forEach(i -> complexListBuilder.withValue(ComplexActingParameterUtils.declareInnerPojo(i)));
        ParameterObjectValue.Builder mapBuilder = ParameterObjectValue.builder();
        mapParam.forEach((arg_0, arg_1) -> ((ParameterObjectValue.Builder)mapBuilder).withParameter(arg_0, arg_1));
        ParameterObjectValue.Builder complexMapBuilder = ParameterObjectValue.builder();
        complexMap.forEach((k, v) -> complexMapBuilder.withParameter(k, ComplexActingParameterUtils.declareInnerPojo(v)));
        return ParameterObjectValue.builder().withParameter("innerPojoParam", ComplexActingParameterUtils.declareInnerPojo(innerPojo)).withParameter("intParam", Integer.toString(intParam)).withParameter("stringParam", stringParam).withParameter("listParam", (ParameterValue)listValueBuilder.build()).withParameter("mapParam", (ParameterValue)mapBuilder.build()).withParameter("complexListParam", (ParameterValue)complexListBuilder.build()).withParameter("complexMapParam", (ParameterValue)complexMapBuilder.build()).build();
    }

    static void forAllComplexActingParameterChanges(ArtifactDeclaration app, String componentLocation, String complexActingParameterName, CheckedConsumer<ComplexActingParameter> newValueConsumer) {
        int defaultInt = DEFAULT_COMPLEX_ACTING_PARAMETER.getIntParam();
        String defaultString = DEFAULT_COMPLEX_ACTING_PARAMETER.getStringParam();
        List<String> defaultList = DEFAULT_COMPLEX_ACTING_PARAMETER.getListParam();
        Map<String, String> defaultMap = DEFAULT_COMPLEX_ACTING_PARAMETER.getMapParam();
        InnerPojo defaultInnerPojo = DEFAULT_COMPLEX_ACTING_PARAMETER.getInnerPojoParam();
        List<InnerPojo> defaultComplexList = DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexListParam();
        Map<String, InnerPojo> defaultComplexMap = DEFAULT_COMPLEX_ACTING_PARAMETER.getComplexMapParam();
        ComplexActingParameter originalComplexActingParameter = new ComplexActingParameter(defaultInt, defaultString, defaultList, defaultMap, defaultInnerPojo, defaultComplexList, defaultComplexMap);
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter);
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setIntParam(1));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setStringParam("one"));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setListParam(Arrays.asList("one", "two", "four")));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setMapParam((Map<String, String>)ImmutableMap.of((Object)"2", (Object)"two", (Object)"3", (Object)"three")));
        InnerPojo innerPojoChangedInt = new InnerPojo(1, defaultString, defaultList, defaultMap);
        InnerPojo innerPojoChangedString = new InnerPojo(defaultInt, "one", defaultList, defaultMap);
        InnerPojo innerPojoChangedList = new InnerPojo(defaultInt, defaultString, Arrays.asList("one", "two", "four"), defaultMap);
        InnerPojo innerPojoChangedMap = new InnerPojo(defaultInt, defaultString, defaultList, (Map<String, String>)ImmutableMap.of((Object)"0", (Object)"two", (Object)"1", (Object)"three"));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedInt));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedString));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedList));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setInnerPojoParam(innerPojoChangedMap));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedInt)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedString)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedList)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexListParam(Collections.singletonList(innerPojoChangedMap)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedInt)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedString)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedList)));
        ComplexActingParameterUtils.modifyAndConsume(app, componentLocation, complexActingParameterName, newValueConsumer, originalComplexActingParameter.copy().setComplexMapParam((Map<String, InnerPojo>)ImmutableMap.of((Object)"0", (Object)innerPojoChangedMap)));
    }

    private static void modifyAndConsume(ArtifactDeclaration app, String componentLocation, String complexActingParameterName, Consumer<ComplexActingParameter> newValueConsumer, ComplexActingParameter complexActingParameter) {
        DeclarationUtils.modifyParameter(app, componentLocation, complexActingParameterName, p -> p.setValue(ComplexActingParameterUtils.declareComplexActingParameter(complexActingParameter)));
        newValueConsumer.accept(complexActingParameter);
    }

    private static ParameterValue declareInnerPojo(InnerPojo innerPojo) {
        ParameterListValue.Builder listBuilder = ParameterListValue.builder();
        innerPojo.getListParam().forEach(arg_0 -> ((ParameterListValue.Builder)listBuilder).withValue(arg_0));
        ParameterObjectValue.Builder mapBuilder = ParameterObjectValue.builder();
        innerPojo.getMapParam().forEach((arg_0, arg_1) -> ((ParameterObjectValue.Builder)mapBuilder).withParameter(arg_0, arg_1));
        return ParameterObjectValue.builder().ofType(InnerPojo.class.getName()).withParameter("intParam", Integer.toString(innerPojo.getIntParam())).withParameter("stringParam", innerPojo.getStringParam()).withParameter("listParam", (ParameterValue)listBuilder.build()).withParameter("mapParam", (ParameterValue)mapBuilder.build()).build();
    }

    static {
        boolean defaultInt = false;
        String defaultString = "zero";
        List<String> defaultList = Arrays.asList("one", "two", "three");
        ImmutableMap defaultMap = ImmutableMap.of((Object)"0", (Object)"zero", (Object)"1", (Object)"one");
        InnerPojo innerPojo = new InnerPojo(0, "zero", defaultList, (Map<String, String>)defaultMap);
        DEFAULT_COMPLEX_ACTING_PARAMETER = new ComplexActingParameter(0, "zero", defaultList, (Map<String, String>)defaultMap, innerPojo, Collections.singletonList(innerPojo), (Map<String, InnerPojo>)ImmutableMap.of((Object)"zero", (Object)innerPojo));
    }
}

