/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Features(value={@Feature(value="Sources"), @Feature(value="SDK Tooling Support")})
@Stories(value={@Story(value="Polling"), @Story(value="Metadata Service")})
public class LazyPollingSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    @Named(value="_muleMetadataService")
    MetadataService metadataService;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    protected String getConfigFile() {
        return "metadata/polling-source-config-without-scheduling-strategy.xml";
    }

    @Test
    public void resolvePollingSourceMetadata() {
        MetadataResult sourceMetadata = this.metadataService.getSourceMetadata(Location.builder().globalName("polling-source").addSourcePart().build());
        MatcherAssert.assertThat((Object)((SourceModel)((ComponentMetadataDescriptor)sourceMetadata.get()).getModel()).getOutput().getType(), (Matcher)Is.isA(StringType.class));
    }
}

