/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.dsl.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentAstBasedValueProviderCacheIdGenerator;
import org.mule.runtime.module.tooling.internal.dsl.model.AbstractMockedValueProviderExtensionTestCase;

public class ComponentAstValueProviderCacheIdGeneratorTestCase
extends AbstractMockedValueProviderExtensionTestCase {
    private Optional<ValueProviderCacheId> computeIdFor(ArtifactDeclaration appDeclaration, String location, String parameterName) throws Exception {
        ArtifactAst app = this.loadApplicationModel(appDeclaration);
        Locator locator = new Locator(app);
        ComponentAstBasedValueProviderCacheIdGenerator cacheIdGenerator = new ComponentAstBasedValueProviderCacheIdGenerator((ComponentLocator)locator);
        ComponentAst component = this.getComponentAst(app, location);
        return cacheIdGenerator.getIdForResolvedValues((Object)component, parameterName);
    }

    private Optional<ParameterizedElementDeclaration> getParameterElementDeclaration(ArtifactDeclaration artifactDeclaration, String location) {
        AtomicBoolean isConnection = new AtomicBoolean(false);
        if (location.endsWith("/connection")) {
            isConnection.set(true);
            location = location.split("/connection")[0];
        }
        return artifactDeclaration.findElement(Location.builderFromStringRepresentation((String)location).build()).map(d -> isConnection.get() ? (ParameterizedElementDeclaration)((ConfigurationElementDeclaration)d).getConnection().orElse(null) : d);
    }

    private void modifyParameter(ArtifactDeclaration artifactDeclaration, String ownerLocation, String parameterName, Consumer<ParameterElementDeclaration> parameterConsumer) {
        this.getParameterElementDeclaration(artifactDeclaration, ownerLocation).map(owner -> owner.getParameterGroups().stream().flatMap(pg -> pg.getParameters().stream()).filter(p -> p.getName().equals(parameterName)).findAny().map(fp -> {
            parameterConsumer.accept((ParameterElementDeclaration)fp);
            return "";
        }).orElseThrow(() -> new RuntimeException("Could not find parameter to modify"))).orElseThrow(() -> new RuntimeException("Location not found"));
    }

    @Test
    public void idForParameterWithNoProviderInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myConfig", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInSource() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/source", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForParameterWithNoProviderInOperation() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        MatcherAssert.assertThat((Object)this.computeIdFor(app, "myFlow/processors/0", "actingParameter").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void idForConfigNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingNotActingParameters() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfigChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> configId = this.computeIdFor(app, "myConfig", "providedParameter");
        MatcherAssert.assertThat((Object)configId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(configId, this.computeIdFor(app, "myConfig", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myFlow/processors/0", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myFlow/processors/0", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessOperationChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceNoChanges() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameter() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myFlow/source", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangingActingParameterInGroup() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myFlow/source", "parameterInGroup", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConfig() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfiglessAndConnectionlessSourceChangesInConnection() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareOperationChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareOperationChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        MatcherAssert.assertThat((Object)opId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(opId, this.computeIdFor(app, "myFlow/processors/0", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConfigAwareSourceChangesInConfigRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionNotRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "actingParameter", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreEqual(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void idForConnectionAwareSourceChangesInConnectionRequiredForMetadata() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> sourceId = this.computeIdFor(app, "myFlow/source", "providedParameter");
        MatcherAssert.assertThat((Object)sourceId.isPresent(), (Matcher)Matchers.is((Object)true));
        this.modifyParameter(app, "myConfig/connection", "requiredForMetadata", p -> p.setValue(ParameterSimpleValue.of((String)"newValue")));
        this.checkIdsAreDifferent(sourceId, this.computeIdFor(app, "myFlow/source", "providedParameter"));
    }

    @Test
    public void equalConfigsWithDifferentNameGetSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithDifferentProviderIdGetDifferentHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareOtherConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreDifferent(config1Id, config2Id);
    }

    @Test
    public void differentConfigsWithSameProviderIdGetSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        ConfigurationElementDeclaration config = (ConfigurationElementDeclaration)app.getGlobalElements().get(0);
        app.addGlobalElement((GlobalElementDeclaration)this.declareOtherConfig((ConnectionElementDeclaration)config.getConnection().get(), "newName", "requiredForMetadata", "actingParameter", "providedParameter", "parameterInGroup"));
        Optional<ValueProviderCacheId> config1Id = this.computeIdFor(app, "myConfig", "providedParameter");
        Optional<ValueProviderCacheId> config2Id = this.computeIdFor(app, "newName", "providedParameter");
        this.checkIdsAreEqual(config1Id, config2Id);
    }

    @Test
    public void differentValueProviderIdGetsDifferentHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Mockito.when((Object)this.valueProviderModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.valueProviderModel.requiresConfiguration()).thenReturn((Object)true);
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithDifferentProviderIdGetsDifferentHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Mockito.when((Object)this.valueProviderModel.getProviderId()).thenReturn((Object)"newValueProviderId");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreDifferent(opId1, opId2);
    }

    @Test
    public void differentOperationsWithSameValueProviderIdGetsSameHash() throws Exception {
        ArtifactDeclaration app = this.getBaseApp();
        Optional<ValueProviderCacheId> opId1 = this.computeIdFor(app, "myFlow/processors/0", "providedParameter");
        Optional<ValueProviderCacheId> opId2 = this.computeIdFor(app, "myFlow/processors/1", "providedParameter");
        this.checkIdsAreEqual(opId1, opId2);
    }

    private static class Locator
    implements ComponentLocator<ComponentAst> {
        private final Map<org.mule.runtime.api.component.location.Location, ComponentAst> components = new HashMap<org.mule.runtime.api.component.location.Location, ComponentAst>();

        Locator(ArtifactAst app) {
            app.topLevelComponentsStream().forEach(this::addComponent);
        }

        public Optional<ComponentAst> get(org.mule.runtime.api.component.location.Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private org.mule.runtime.api.component.location.Location getLocation(ComponentAst component) {
            return org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)component.getLocation().getLocation()).build();
        }

        private void addComponent(ComponentAst component) {
            this.components.put(this.getLocation(component), component);
            component.directChildrenStream().forEach(this::addComponent);
        }
    }
}

