/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.dsl.model;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;

public class DeclarationUtils {
    private DeclarationUtils() {
    }

    static Optional<ParameterizedElementDeclaration> getParameterElementDeclaration(ArtifactDeclaration artifactDeclaration, String location) {
        AtomicBoolean isConnection = new AtomicBoolean(false);
        if (location.endsWith("/connection")) {
            isConnection.set(true);
            location = location.split("/connection")[0];
        }
        return artifactDeclaration.findElement(Location.builderFromStringRepresentation((String)location).build()).map(d -> isConnection.get() ? (ParameterizedElementDeclaration)((ConfigurationElementDeclaration)d).getConnection().orElse(null) : d);
    }

    static void removeParameter(ArtifactDeclaration artifactDeclaration, String ownerLocation, String parameterName) {
        if (!DeclarationUtils.getParameterElementDeclaration(artifactDeclaration, ownerLocation).map(owner -> owner.getParameterGroups().stream().filter(pg -> pg.getParameters().removeIf(p -> p.getName().equals(parameterName))).findAny()).orElseThrow(() -> new RuntimeException("Location not found")).isPresent()) {
            throw new RuntimeException("Could not remove parameter from component");
        }
    }

    static void modifyParameter(ArtifactDeclaration artifactDeclaration, String ownerLocation, String parameterName, Consumer<ParameterElementDeclaration> parameterConsumer) {
        DeclarationUtils.getParameterElementDeclaration(artifactDeclaration, ownerLocation).map(owner -> owner.getParameterGroups().stream().flatMap(pg -> pg.getParameters().stream()).filter(p -> p.getName().equals(parameterName)).findAny().map(fp -> {
            parameterConsumer.accept((ParameterElementDeclaration)fp);
            return "";
        }).orElseThrow(() -> new RuntimeException("Could not find parameter to modify"))).orElseThrow(() -> new RuntimeException("Location not found"));
    }
}

