/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.params;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterExtractor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ParameterExtractorCorrectDWTestCase
extends AbstractMuleContextTestCase {
    private ExpressionManager expressionManager;

    @Before
    public void setUp() throws Exception {
        this.expressionManager = muleContext.getExpressionManager();
    }

    @Test
    public void simpleString() {
        this.generateDeclarationAndEvaluate("This is a simple string");
    }

    @Test
    public void doubleQuotes() {
        this.generateDeclarationAndEvaluate("This is \"not\" so simple");
    }

    @Test
    public void singleQuotes() {
        this.generateDeclarationAndEvaluate("This is 'not' so simple");
    }

    @Test
    public void escapedSingleQuotes() {
        this.generateDeclarationAndEvaluate("This is \\'not\\' so simple");
    }

    @Test
    public void multipleEscapesInSingleQuotes() {
        this.generateDeclarationAndEvaluate("This is \\\\'not\\\\' so simple");
    }

    @Test
    public void escapedDoubleQuotes() {
        this.generateDeclarationAndEvaluate("This is \\\"not\\\" so simple");
    }

    @Test
    public void multipleEscapesInDoubleQuotes() {
        this.generateDeclarationAndEvaluate("This is \\\\\"not\\\\\" so simple");
    }

    @Test
    public void multipleDoubleQuotes() {
        this.generateDeclarationAndEvaluate("\"This\" \"is\" \"not\" \"so\" \"simple\"");
    }

    @Test
    public void multipleSingleQuotes() {
        this.generateDeclarationAndEvaluate("'This' 'is' 'not' 'so' 'simple'");
    }

    @Test
    public void singleQuoteXML() {
        this.generateDeclarationAndEvaluate("<?xml version='1.0' encoding='UTF-8' standalone='yes'?> <tag>tagValue</tag>");
    }

    @Test
    public void combinedQuotes() {
        this.generateDeclarationAndEvaluate("'single' and \"double\" quotes");
    }

    @Test
    public void doubleQuoteXML() {
        this.generateDeclarationAndEvaluate("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?> <tag>tagValue</tag>");
    }

    @Test
    public void doubleQuotesJson() {
        this.generateDeclarationAndEvaluate("{\"property\": \"value\"}");
    }

    private void generateDeclarationAndEvaluate(String parameterInput) {
        TypedValue dwExpression = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)parameterInput));
        String bindingVariable = "bindingVariable";
        BindingContext context = BindingContext.builder().addBinding("bindingVariable", dwExpression).build();
        TypedValue outputValue = this.expressionManager.evaluate("#[bindingVariable]", DataType.STRING, context);
        Assert.assertThat((Object)outputValue.getValue(), (Matcher)Matchers.equalTo((Object)parameterInput));
    }
}

