/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.params;

import java.time.LocalDateTime;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterExtractor;

public class ParameterExtractorTestCase {
    @Test
    public void dateTimeTypeAsDateTime() {
        String param = "my parameter";
        DateTimeType dateTimeType = new BaseTypeBuilder(MetadataFormat.JAVA).dateTimeType().build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)dateTimeType);
        this.checkContains(extracted, "as DateTime");
    }

    @Test
    public void dateTypeAsDate() {
        String param = "my parameter";
        DateType dateType = new BaseTypeBuilder(MetadataFormat.JAVA).dateType().build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)dateType);
        this.checkContains(extracted, "as Date");
    }

    @Test
    public void localDateTimeTypeAsLocalDateTime() {
        String param = "my parameter";
        LocalDateTimeType localDateTimeType = new BaseTypeBuilder(MetadataFormat.JAVA).localDateTimeType().build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)localDateTimeType);
        this.checkContains(extracted, "as LocalDateTime");
    }

    @Test
    public void localTimeTypeAsLocalTime() {
        String param = "my parameter";
        LocalTimeType localTimeType = new BaseTypeBuilder(MetadataFormat.JAVA).localTimeType().build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)localTimeType);
        this.checkContains(extracted, "as LocalTime");
    }

    @Test
    public void javaUtilDateAsDateTime() {
        String param = "my parameter";
        DateType dateTimeType = new BaseTypeBuilder(MetadataFormat.JAVA).dateType().with((TypeAnnotation)new TypeIdAnnotation(Date.class.getName())).build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)dateTimeType);
        this.checkContains(extracted, "as DateTime");
    }

    @Test
    public void javaLocalDateTimeAsLocalDateTime() {
        String param = "my parameter";
        DateTimeType dateTimeType = new BaseTypeBuilder(MetadataFormat.JAVA).dateTimeType().with((TypeAnnotation)new TypeIdAnnotation(LocalDateTime.class.getName())).build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)ParameterSimpleValue.plain((String)"my parameter"), (MetadataType)dateTimeType);
        this.checkContains(extracted, "as LocalDateTime");
    }

    @Test
    public void notMatchingTypeAndDeclarationStillWorks() {
        DefaultStringType metadataType = new BaseTypeBuilder(MetadataFormat.JAVA).stringType().build();
        ParameterObjectValue level0 = ParameterObjectValue.builder().withParameter("field", ParameterSimpleValue.plain((String)"value")).build();
        ParameterObjectValue parameterValue = ParameterObjectValue.builder().withParameter("level0", (ParameterValue)level0).build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)parameterValue, (MetadataType)metadataType);
        this.checkContains(extracted, "{\"level0\":{\"field\":\"value\"}}");
    }

    @Test
    public void arrayOfDate() {
        String date = "my date";
        DateType dateType = new BaseTypeBuilder(MetadataFormat.JAVA).dateType().build();
        ArrayType metadataType = new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of((MetadataType)dateType).build();
        ParameterListValue parameterValue = ParameterListValue.builder().withValue("my date").build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)parameterValue, (MetadataType)metadataType);
        this.checkContains(extracted, "as Date");
    }

    @Test
    public void objectOfDate() {
        String date = "my date";
        DateType dateType = new BaseTypeBuilder(MetadataFormat.JAVA).dateType().build();
        ObjectTypeBuilder metadataTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        metadataTypeBuilder.addField().key("myDate").value((MetadataType)dateType);
        ParameterObjectValue parameterValue = ParameterObjectValue.builder().withParameter("myDate", "my date").build();
        TypedValue extracted = ParameterExtractor.asDataWeaveExpression((ParameterValue)parameterValue, (MetadataType)metadataTypeBuilder.build());
        this.checkContains(extracted, "as Date");
    }

    private void checkContains(TypedValue<?> typedValue, String content) {
        String value = (String)typedValue.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.containsString((String)content));
    }
}

