/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class SourceWithCallbackParametersMetadataTestCase
extends MetadataExtensionFunctionalTestCase<SourceModel> {
    public SourceWithCallbackParametersMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
        this.provider = resolutionType == MetadataExtensionFunctionalTestCase.ResolutionType.EXPLICIT_RESOLUTION ? MetadataService::getSourceMetadata : (metadataService, componentId, key) -> metadataService.getSourceMetadata(componentId);
        this.location = Location.builder().globalName("sourceMetadataWithCallbackParameters").addSourcePart().build();
    }

    protected String getConfigFile() {
        return "metadata/metadata-tests.xml";
    }

    @Test
    public void getSourceDynamicInputMetadataFromCallbackParameters() throws Exception {
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        MatcherAssert.assertThat(result, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        ComponentMetadataDescriptor componentMetadata = (ComponentMetadataDescriptor)result.get();
        SourceModel sourceModel = (SourceModel)componentMetadata.getModel();
        SourceCallbackModel sourceSuccessCallback = (SourceCallbackModel)sourceModel.getSuccessCallback().get();
        this.assertExpectedType(this.getParameter((ParameterizedModel)sourceSuccessCallback, "response").getType(), this.personType);
        this.assertExpectedType(this.getParameter((ParameterizedModel)sourceSuccessCallback, "successObject").getType(), this.carType);
        SourceCallbackModel sourceErrorCallback = (SourceCallbackModel)sourceModel.getErrorCallback().get();
        this.assertExpectedType(this.getParameter((ParameterizedModel)sourceErrorCallback, "response").getType(), this.houseType);
        this.assertExpectedType(this.getParameter((ParameterizedModel)sourceErrorCallback, "errorObject").getType(), this.personType);
    }

    private ParameterModel getParameter(ParameterizedModel owner, String parameterName) {
        return owner.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(parameterName)).findFirst().orElse(null);
    }
}

