/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.tck.junit4.matcher.value.ValueResultSuccessMatcher;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;

@Feature(value="SDK Tooling Support")
@Story(value="Value Providers Service")
@ArtifactClassLoaderRunnerConfig(applicationSharedRuntimeLibs={"org.mule.tests:mule-tests-model"})
public abstract class AbstractValuesTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    @Named(value="_muleValueProviderService")
    private ValueProviderService valueProviderService;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    Matcher<Iterable<Value>> hasValues(String ... values) {
        Set<ValueMatcher> options = Arrays.stream(values).map(ValueMatcher::valueWithId).collect(Collectors.toSet());
        return this.hasValues(options.toArray(new ValueMatcher[0]));
    }

    Matcher<Iterable<Value>> hasValues(ValueMatcher ... valuesMatchers) {
        return IsIterableContaining.hasItems((Matcher[])valuesMatchers);
    }

    Set<Value> getValuesFromSource(String flowName, String parameterName) throws Exception {
        ValueResult valueResult = this.valueProviderService.getValues(Location.builder().globalName(flowName).addSourcePart().build(), parameterName);
        MatcherAssert.assertThat((Object)valueResult, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return valueResult.getValues();
    }

    Set<Value> getValuesFromSource(String flowName, String parameterName, String targetSelector) throws Exception {
        ValueResult valueResult = this.valueProviderService.getFieldValues(Location.builder().globalName(flowName).addSourcePart().build(), parameterName, targetSelector);
        MatcherAssert.assertThat((Object)valueResult, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return valueResult.getValues();
    }

    Set<Value> getValues(String flowName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResult(flowName, parameterName));
    }

    ValueResult getValueResult(String flowName, String parameterName) throws Exception {
        Location location = Location.builder().globalName(flowName).addProcessorsPart().addIndexPart(0).build();
        return this.valueProviderService.getValues(location, parameterName);
    }

    Set<Value> getValues(String flowName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResult(flowName, parameterName, targetSelector));
    }

    ValueResult getValueResult(String flowName, String parameterName, String targetSelector) throws Exception {
        Location location = Location.builder().globalName(flowName).addProcessorsPart().addIndexPart(0).build();
        return this.valueProviderService.getFieldValues(location, parameterName, targetSelector);
    }

    Set<Value> getValuesFromConfig(String configName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResultFromConfig(configName, parameterName));
    }

    public ValueResult getValueResultFromConfig(String configName, String parameterName) {
        return this.valueProviderService.getValues(Location.builder().globalName(configName).build(), parameterName);
    }

    Set<Value> getFieldValuesFromConfig(String configName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getFieldValuesResultFromConfig(configName, parameterName, targetSelector));
    }

    public ValueResult getFieldValuesResultFromConfig(String configName, String parameterName, String targetSelector) {
        return this.valueProviderService.getFieldValues(Location.builder().globalName(configName).build(), parameterName, targetSelector);
    }

    Set<Value> getValuesFromConnection(String configName, String parameterName) throws Exception {
        return this.checkResultAndRetrieveValues(this.getValueResultFromConnection(configName, parameterName));
    }

    public ValueResult getValueResultFromConnection(String configName, String parameterName) {
        return this.valueProviderService.getValues(Location.builder().globalName(configName).addConnectionPart().build(), parameterName);
    }

    Set<Value> getFieldValuesFromConnection(String configName, String parameterName, String targetSelector) throws Exception {
        return this.checkResultAndRetrieveValues(this.getFieldValueResultFromConnection(configName, parameterName, targetSelector));
    }

    public ValueResult getFieldValueResultFromConnection(String configName, String parameterName, String targetSelector) {
        return this.valueProviderService.getFieldValues(Location.builder().globalName(configName).addConnectionPart().build(), parameterName, targetSelector);
    }

    private Set<Value> checkResultAndRetrieveValues(ValueResult values) throws ValueResolvingException {
        MatcherAssert.assertThat((Object)values, (Matcher)ValueResultSuccessMatcher.isSuccess());
        return values.getValues();
    }
}

