/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;

@Feature(value="Java SDK")
@Story(value="javax.inject compatibility")
@ArtifactClassLoaderRunnerConfig(applicationSharedRuntimeLibs={"org.mule.tests:mule-tests-model"})
public class JavaxInjectCompatibilityToolingTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    @Named(value="_muleSampleDataService")
    private SampleDataService sampleDataService;
    @Inject
    @Named(value="_muleValueProviderService")
    private ValueProviderService valueProviderService;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    protected String getConfigFile() {
        return "inject/javax-inject-compatibility-config.xml";
    }

    @Test
    public void sampleData() throws SampleDataException {
        Message sampleData = this.sampleDataService.getSampleData("Javax Inject compatibility Test Extension", "execute", Collections.emptyMap(), Optional::empty);
        MatcherAssert.assertThat((Object)sampleData.getPayload().getValue(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }

    @Test
    public void valueProviders() {
        Location location = Location.builder().globalName("valueProvider").addProcessorsPart().addIndexPart(0).build();
        ValueResult values = this.valueProviderService.getFieldValues(location, "param", null);
        MatcherAssert.assertThat((Object)values.getValues(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)((Value)values.getValues().iterator().next()).getId(), (Matcher)Is.is((Object)Charset.defaultCharset().name()));
    }
}

