/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.module.tooling.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.connection.ConnectionValidationResultFailureMatcher;
import org.mule.tck.junit4.matcher.connection.ConnectionValidationResultSuccessMatcher;
import org.mule.tck.util.MuleContextUtils;

public class DefaultConnectivityTestingServiceTestCase
extends AbstractMuleTestCase {
    private static final String TEST_IDENTIFIER = "testIdentifier";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final MuleContextWithRegistry mockMuleContext = (MuleContextWithRegistry)Mockito.mock(MuleContextWithRegistry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final ConnectivityTestingStrategy mockConnectivityTestingStrategy = (ConnectivityTestingStrategy)Mockito.mock(ConnectivityTestingStrategy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private DefaultConnectivityTestingService connectivityTestingService;
    private final Component fakeConnectivityTestingObject = (Component)Mockito.mock(Component.class);

    @Before
    public void createConnectivityService() throws InitialisationException {
        this.connectivityTestingService = new DefaultConnectivityTestingService();
        this.connectivityTestingService.setServiceRegistry(() -> Arrays.asList(this.mockConnectivityTestingStrategy).stream());
        this.connectivityTestingService.setMuleContext((MuleContext)this.mockMuleContext);
        this.connectivityTestingService.setLocator(this.mockMuleContext.getConfigurationComponentLocator());
        Mockito.when((Object)this.mockMuleContext.getConfigurationComponentLocator().find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of(this.fakeConnectivityTestingObject));
        Mockito.when((Object)this.mockConnectivityTestingStrategy.accepts((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)true);
        MuleContextUtils.registerIntoMockContext((MuleContext)this.mockMuleContext, (String)TEST_IDENTIFIER, (Object)this.fakeConnectivityTestingObject);
        this.connectivityTestingService.initialise();
    }

    @Test
    public void testConnectionThrowsException() throws Exception {
        RuntimeException exception = new RuntimeException();
        Mockito.when((Object)this.mockConnectivityTestingStrategy.testConnectivity((Object)this.fakeConnectivityTestingObject)).thenThrow(new Throwable[]{exception});
        ConnectionValidationResult validationResult = this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
        MatcherAssert.assertThat((Object)validationResult, (Matcher)ConnectionValidationResultFailureMatcher.isFailure());
        MatcherAssert.assertThat((Object)validationResult.getException(), (Matcher)Is.is((Object)exception));
    }

    @Test
    public void testConnection() {
        Mockito.when((Object)this.mockConnectivityTestingStrategy.testConnectivity((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)ConnectionValidationResult.success());
        ConnectionValidationResult validationResult = this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
        MatcherAssert.assertThat((Object)validationResult, (Matcher)ConnectionValidationResultSuccessMatcher.isSuccess());
    }

    @Test
    public void testObjectNotSupported() {
        Mockito.reset((Object[])new ConnectivityTestingStrategy[]{this.mockConnectivityTestingStrategy});
        Mockito.when((Object)this.mockConnectivityTestingStrategy.accepts((Object)this.fakeConnectivityTestingObject)).thenReturn((Object)false);
        this.expectedException.expect(UnsupportedConnectivityTestingObjectException.class);
        this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
    }

    @Test
    public void nonExistentConnectivityTestingObject() {
        Mockito.reset((Object[])new MuleContextWithRegistry[]{this.mockMuleContext});
        Mockito.when((Object)this.mockMuleContext.getConfigurationComponentLocator().find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.empty());
        this.connectivityTestingService.setLocator(this.mockMuleContext.getConfigurationComponentLocator());
        this.expectedException.expect(ObjectNotFoundException.class);
        this.connectivityTestingService.testConnection(Location.builder().globalName(TEST_IDENTIFIER).build());
    }
}

