/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import static org.mule.runtime.module.troubleshooting.internal.TroubleshootingTestUtils.mockServiceRepository;
import static org.mule.test.allure.AllureConstants.SupportabilityFeature.SUPPORTABILITY;
import static org.mule.test.allure.AllureConstants.SupportabilityFeature.SupportabilityStory.SCHEDULERS;

import static java.lang.System.lineSeparator;
import static java.util.Collections.emptyMap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.service.ServiceRepository;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import org.junit.Before;
import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(SUPPORTABILITY)
@Story(SCHEDULERS)
public class SchedulersStateOperationTestCase {

  private ServiceRepository serviceRepository;
  private SchedulersStateOperation schedulersStateOperation;

  @Before
  public void setup() {
    serviceRepository = mockServiceRepository();
    schedulersStateOperation = new SchedulersStateOperation(serviceRepository);
  }

  @Test
  public void allSchedulers() throws IOException {
    final Writer writer = new StringWriter();
    schedulersStateOperation.getCallback().execute(emptyMap(), writer);
    Object result = writer.toString();

    String expected =
        "\"Sch 1\" (CPU_LITE)" + lineSeparator()
            + "  Active tasks: 8" + lineSeparator()
            + "  Queued tasks: 35" + lineSeparator()
            + "   Rejections:   2 /   6 /   13 /   24" + lineSeparator()
            + "" + lineSeparator()
            + "\"Sch 2\" (IO)" + lineSeparator()
            + "  Active tasks: 3" + lineSeparator()
            + "   Throttles:    2 /   7 /   14 /   27" + lineSeparator()
            + lineSeparator();
    assertThat(result, is(equalTo(expected)));
  }

}
