/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.runtime.api.profiling.ProfilingEventContext;

import java.util.Optional;

/**
 * A {@link ProfilingEventContext} associated to extension profiling events. It allows to retrieve generic data produced by an
 * extension for profiling extension-specific behavior. This type of events can be discriminated by the profiling data source
 * identifier (for example the HTTP Connector) and extension event subtype which allows to indicate the profiling event subtypes
 * associated to that extension (for example An HTTP Request response).
 *
 * @since 1.0.0
 */
public interface ExtensionProfilingEventContext extends ProfilingEventContext {

  /**
   * @return an identifier for the extension associated to this profiling event. This is used to identify the source of the data
   *         (for example a particular connector).
   */
  String getProfilingDataSourceIdentifier();

  /**
   * @return an identifier for the extension event sybtype. An extension may produce data associated
   */
  String getExtensionEventSubtypeIdentifier();

  /**
   * @param key the key for the the element in the context to be retrieved.
   * @return the element in the context corresponding to the key.
   */
  Optional<Object> get(String key);

}
